/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.batch.statement;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;

public final class BatchStatementExecutor {
    private final Statement statement;
    private final Collection<String> batchedSQLs = new LinkedList<String>();

    public void addBatch(String sql) {
        this.batchedSQLs.add(sql);
    }

    public int[] executeBatch() throws SQLException {
        int[] result = new int[this.batchedSQLs.size()];
        int index = 0;
        for (String each : this.batchedSQLs) {
            result[index++] = this.statement.executeUpdate(each);
        }
        return result;
    }

    public void clear() {
        this.batchedSQLs.clear();
    }

    @Generated
    public BatchStatementExecutor(Statement statement) {
        this.statement = statement;
    }
}

