/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.select;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptGroupByItemTokenGenerator
implements CollectionSQLTokenGenerator<SelectStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsGroupByItem((SelectStatementContext)sqlStatementContext);
    }

    private boolean containsGroupByItem(SelectStatementContext sqlStatementContext) {
        if (!sqlStatementContext.getGroupByContext().getItems().isEmpty()) {
            return true;
        }
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            if (!this.containsGroupByItem(each)) continue;
            return true;
        }
        return false;
    }

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (OrderByItem each : this.getGroupByItems(sqlStatementContext)) {
            if (!(each.getSegment() instanceof ColumnOrderByItemSegment)) continue;
            ColumnSegment columnSegment = ((ColumnOrderByItemSegment)each.getSegment()).getColumn();
            this.generateSQLToken(columnSegment, sqlStatementContext.getDatabaseType()).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SubstitutableColumnNameToken> generateSQLToken(ColumnSegment columnSegment, DatabaseType databaseType) {
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(columnSegment.getColumnBoundInfo().getOriginalTable().getValue());
        String columnName = columnSegment.getColumnBoundInfo().getOriginalColumn().getValue();
        if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName)) {
            return Optional.empty();
        }
        EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnName);
        int startIndex = columnSegment.getOwner().isPresent() ? ((OwnerSegment)columnSegment.getOwner().get()).getStopIndex() + 2 : columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        return Optional.of(encryptColumn.getAssistedQuery().map(optional -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(optional.getName(), columnSegment.getIdentifier().getQuoteCharacter(), databaseType), databaseType)).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(encryptColumn.getCipher().getName(), columnSegment.getIdentifier().getQuoteCharacter(), databaseType), databaseType)));
    }

    private Collection<OrderByItem> getGroupByItems(SelectStatementContext sqlStatementContext) {
        LinkedList<OrderByItem> result = new LinkedList<OrderByItem>(sqlStatementContext.getGroupByContext().getItems());
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            result.addAll(this.getGroupByItems(each));
        }
        return result;
    }

    private Collection<Projection> createColumnProjections(String columnName, QuoteCharacter quoteCharacter, DatabaseType databaseType) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, databaseType));
    }

    @Generated
    public EncryptGroupByItemTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

