/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;

public final class EncryptConditionEngine {
    private static final Set<String> LOGICAL_OPERATOR = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> SUPPORTED_COMPARE_OPERATOR = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final EncryptRule rule;
    private final ShardingSphereDatabase database;

    public Collection<EncryptCondition> createEncryptConditions(Collection<WhereSegment> whereSegments) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractor.extractAndPredicates((ExpressionSegment)each.getExpr());
            for (AndPredicate predicate : andPredicates) {
                this.addEncryptConditions(result, predicate.getPredicates());
            }
        }
        return result;
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, Collection<ExpressionSegment> predicates) {
        HashSet<Integer> stopIndexes = new HashSet<Integer>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            if (!stopIndexes.add(each.getStopIndex())) continue;
            this.addEncryptConditions(encryptConditions, each);
        }
    }

    private void addEncryptConditions(Collection<EncryptCondition> encryptConditions, ExpressionSegment expression) {
        if (!this.findNotContainsNullLiteralsExpression(expression).isPresent()) {
            return;
        }
        for (ColumnSegment each : ColumnExtractor.extract((ExpressionSegment)expression)) {
            String tableName = each.getColumnBoundInfo().getOriginalTable().getValue();
            Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(tableName);
            if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(each.getColumnBoundInfo().getOriginalColumn().getValue())) continue;
            this.createEncryptCondition(expression, tableName).ifPresent(encryptConditions::add);
        }
    }

    private Optional<ExpressionSegment> findNotContainsNullLiteralsExpression(ExpressionSegment expression) {
        if (this.isContainsNullLiterals(expression)) {
            return Optional.empty();
        }
        if (expression instanceof BinaryOperationExpression && this.isContainsNullLiterals(((BinaryOperationExpression)expression).getRight())) {
            return Optional.empty();
        }
        return Optional.ofNullable(expression);
    }

    private boolean isContainsNullLiterals(ExpressionSegment expression) {
        if (!(expression instanceof LiteralExpressionSegment)) {
            return false;
        }
        String literals = String.valueOf(((LiteralExpressionSegment)expression).getLiterals());
        return "NULL".equalsIgnoreCase(literals) || "NOT NULL".equalsIgnoreCase(literals);
    }

    private Optional<EncryptCondition> createEncryptCondition(ExpressionSegment expression, String tableName) {
        if (expression instanceof BinaryOperationExpression) {
            return this.createBinaryEncryptCondition((BinaryOperationExpression)expression, tableName);
        }
        if (expression instanceof InExpression) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, (InExpression)expression, ((InExpression)expression).getRight());
        }
        if (expression instanceof BetweenExpression) {
            throw new UnsupportedEncryptSQLException("BETWEEN...AND...");
        }
        return Optional.empty();
    }

    private Optional<EncryptCondition> createBinaryEncryptCondition(BinaryOperationExpression expression, String tableName) {
        String operator = expression.getOperator();
        if (LOGICAL_OPERATOR.contains(operator)) {
            return Optional.empty();
        }
        ShardingSpherePreconditions.checkContains(SUPPORTED_COMPARE_OPERATOR, (Object)operator, () -> new UnsupportedEncryptSQLException(operator));
        return this.createCompareEncryptCondition(tableName, expression, expression.getRight());
    }

    private Optional<EncryptCondition> createCompareEncryptCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        if (!(expression.getLeft() instanceof ColumnSegment) || compareRightValue instanceof SubqueryExpressionSegment) {
            return Optional.empty();
        }
        if (compareRightValue instanceof SimpleExpressionSegment) {
            return Optional.of(this.createEncryptBinaryOperationCondition(tableName, expression, compareRightValue));
        }
        if (compareRightValue instanceof ListExpression) {
            return Optional.of(this.createEncryptBinaryOperationCondition(tableName, expression, (ExpressionSegment)((ListExpression)compareRightValue).getItems().get(0)));
        }
        return Optional.empty();
    }

    private EncryptBinaryCondition createEncryptBinaryOperationCondition(String tableName, BinaryOperationExpression expression, ExpressionSegment compareRightValue) {
        ColumnSegment columnSegment = (ColumnSegment)expression.getLeft();
        return new EncryptBinaryCondition(columnSegment, tableName, expression.getOperator(), compareRightValue.getStartIndex(), expression.getStopIndex(), compareRightValue);
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, InExpression inExpression, ExpressionSegment inRightValue) {
        if (!(inExpression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inExpression.getExpressionList()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        if (expressionSegments.isEmpty()) {
            return Optional.empty();
        }
        ColumnSegment columnSegment = (ColumnSegment)inExpression.getLeft();
        return Optional.of(new EncryptInCondition(columnSegment, tableName, inRightValue.getStartIndex(), inRightValue.getStopIndex(), expressionSegments));
    }

    @Generated
    public EncryptConditionEngine(EncryptRule rule, ShardingSphereDatabase database) {
        this.rule = rule;
        this.database = database;
    }

    static {
        LOGICAL_OPERATOR.add("AND");
        LOGICAL_OPERATOR.add("&&");
        LOGICAL_OPERATOR.add("OR");
        LOGICAL_OPERATOR.add("||");
        SUPPORTED_COMPARE_OPERATOR.add("=");
        SUPPORTED_COMPARE_OPERATOR.add("<>");
        SUPPORTED_COMPARE_OPERATOR.add("!=");
        SUPPORTED_COMPARE_OPERATOR.add(">");
        SUPPORTED_COMPARE_OPERATOR.add("<");
        SUPPORTED_COMPARE_OPERATOR.add(">=");
        SUPPORTED_COMPARE_OPERATOR.add("<=");
        SUPPORTED_COMPARE_OPERATOR.add("IS");
        SUPPORTED_COMPARE_OPERATOR.add("LIKE");
    }
}

