/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.with;

import java.util.Collection;
import org.apache.shardingsphere.encrypt.exception.syntax.UnsupportedEncryptSQLException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.WithAvailable;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;

public final class EncryptWithClauseSupportedChecker
implements SupportedSQLChecker<SQLStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WithAvailable && ((WithAvailable)sqlStatementContext).getWith().isPresent();
    }

    public void check(EncryptRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, SQLStatementContext sqlStatementContext) {
        Collection tableNames = SQLStatementContextExtractor.getTableNames((ShardingSphereDatabase)database, (SQLStatementContext)sqlStatementContext);
        for (String each : tableNames) {
            ShardingSpherePreconditions.checkState((!rule.findEncryptTable(each).isPresent() ? 1 : 0) != 0, () -> new UnsupportedEncryptSQLException("WITH"));
        }
    }
}

