/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.kernel;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.apache.shardingsphere.distsql.parser.autogen.KernelDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.KernelDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.statement.ral.queryable.convert.ConvertYamlConfigurationStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportMetaDataStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportStorageNodesStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowComputeNodeInfoStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowComputeNodeModeStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowComputeNodesStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowDistVariableStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowDistVariablesStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowPluginsStatement;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowTableMetaDataStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.AlterComputeNodeStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.ImportDatabaseConfigurationStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.ImportMetaDataStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.LabelComputeNodeStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.LockClusterStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.RefreshDatabaseMetaDataStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.RefreshTableMetaDataStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.SetComputeNodeStateStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.SetDistVariableStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.UnlabelComputeNodeStatement;
import org.apache.shardingsphere.distsql.statement.ral.updatable.UnlockClusterStatement;
import org.apache.shardingsphere.distsql.statement.rdl.resource.unit.type.AlterStorageUnitStatement;
import org.apache.shardingsphere.distsql.statement.rdl.resource.unit.type.RegisterStorageUnitStatement;
import org.apache.shardingsphere.distsql.statement.rdl.resource.unit.type.UnregisterStorageUnitStatement;
import org.apache.shardingsphere.distsql.statement.rql.resource.ShowLogicalTablesStatement;
import org.apache.shardingsphere.distsql.statement.rql.resource.ShowStorageUnitsStatement;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.ShowRulesUsedStorageUnitStatement;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;

public final class KernelDistSQLStatementVisitor
extends KernelDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitRegisterStorageUnit(KernelDistSQLStatementParser.RegisterStorageUnitContext ctx) {
        return new RegisterStorageUnitStatement(null != ctx.ifNotExists(), this.getStorageUnits(ctx.storageUnitsDefinition()), this.getExpectedPrivileges(ctx.checkPrivileges()));
    }

    @Override
    public ASTNode visitAlterStorageUnit(KernelDistSQLStatementParser.AlterStorageUnitContext ctx) {
        return new AlterStorageUnitStatement(this.getStorageUnits(ctx.storageUnitsDefinition()), this.getExpectedPrivileges(ctx.checkPrivileges()));
    }

    private Collection<DataSourceSegment> getStorageUnits(KernelDistSQLStatementParser.StorageUnitsDefinitionContext ctx) {
        return ctx.storageUnitDefinition().stream().map(each -> (DataSourceSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
    }

    private Collection<String> getExpectedPrivileges(KernelDistSQLStatementParser.CheckPrivilegesContext ctx) {
        return null == ctx ? Collections.emptySet() : (Collection)ctx.privilegeType().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
    }

    @Override
    public ASTNode visitShowTableMetadata(KernelDistSQLStatementParser.ShowTableMetadataContext ctx) {
        Collection tableNames = ctx.tableName().stream().map(this::getIdentifierValue).collect(Collectors.toSet());
        return new ShowTableMetaDataStatement(tableNames, null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitStorageUnitDefinition(KernelDistSQLStatementParser.StorageUnitDefinitionContext ctx) {
        String user = this.getIdentifierValue((ParseTree)ctx.user());
        String password = null == ctx.password() ? "" : new StringLiteralValue(StringUtils.replaceStandardEscapes((String)ctx.password().getText())).getValue();
        Properties props = this.getProperties(ctx.propertiesDefinition());
        return null == ctx.urlSource() ? new HostnameAndPortBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.simpleSource().hostname()), ctx.simpleSource().port().getText(), this.getIdentifierValue((ParseTree)ctx.simpleSource().dbName()), user, password, props) : new URLBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.urlSource().url()), user, password, props);
    }

    @Override
    public ASTNode visitShowComputeNodes(KernelDistSQLStatementParser.ShowComputeNodesContext ctx) {
        return new ShowComputeNodesStatement();
    }

    @Override
    public ASTNode visitShowComputeNodeInfo(KernelDistSQLStatementParser.ShowComputeNodeInfoContext ctx) {
        return new ShowComputeNodeInfoStatement();
    }

    @Override
    public ASTNode visitShowComputeNodeMode(KernelDistSQLStatementParser.ShowComputeNodeModeContext ctx) {
        return new ShowComputeNodeModeStatement();
    }

    @Override
    public ASTNode visitEnableComputeNode(KernelDistSQLStatementParser.EnableComputeNodeContext ctx) {
        return this.buildSetComputeNodeStateStatement(ctx.ENABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitDisableComputeNode(KernelDistSQLStatementParser.DisableComputeNodeContext ctx) {
        return this.buildSetComputeNodeStateStatement(ctx.DISABLE().getText().toUpperCase(), ctx.instanceId());
    }

    @Override
    public ASTNode visitLabelComputeNode(KernelDistSQLStatementParser.LabelComputeNodeContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new LabelComputeNodeStatement(null != ctx.RELABEL(), this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    @Override
    public ASTNode visitUnlabelComputeNode(KernelDistSQLStatementParser.UnlabelComputeNodeContext ctx) {
        Collection labels = ctx.label().stream().map(this::getIdentifierValue).collect(Collectors.toList());
        return new UnlabelComputeNodeStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), labels);
    }

    private SetComputeNodeStateStatement buildSetComputeNodeStateStatement(String status, KernelDistSQLStatementParser.InstanceIdContext instanceIdContext) {
        return new SetComputeNodeStateStatement(status, this.getIdentifierValue((ParseTree)instanceIdContext));
    }

    @Override
    public ASTNode visitAlterComputeNode(KernelDistSQLStatementParser.AlterComputeNodeContext ctx) {
        return new AlterComputeNodeStatement(this.getIdentifierValue((ParseTree)ctx.instanceId()), this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValues()));
    }

    private Properties getProperties(KernelDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (KernelDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitUnregisterStorageUnit(KernelDistSQLStatementParser.UnregisterStorageUnitContext ctx) {
        boolean ignoreSingleTables = ctx.ignoreTables() instanceof KernelDistSQLStatementParser.IgnoreSingleAndBroadcastTablesContext || ctx.ignoreTables() instanceof KernelDistSQLStatementParser.IgnoreSingleTablesContext;
        boolean ignoreBroadcastTables = ctx.ignoreTables() instanceof KernelDistSQLStatementParser.IgnoreSingleAndBroadcastTablesContext || ctx.ignoreTables() instanceof KernelDistSQLStatementParser.IgnoreBroadcastTablesContext;
        return new UnregisterStorageUnitStatement(null != ctx.ifExists(), (Collection)ctx.storageUnitName().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()), ignoreSingleTables, ignoreBroadcastTables);
    }

    @Override
    public ASTNode visitShowStorageUnits(KernelDistSQLStatementParser.ShowStorageUnitsContext ctx) {
        DatabaseSegment database = null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName());
        String likePattern = null == ctx.showLike() ? null : this.getIdentifierValue((ParseTree)ctx.showLike().likePattern());
        return new ShowStorageUnitsStatement(database, likePattern);
    }

    @Override
    public ASTNode visitDatabaseName(KernelDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSetDistVariable(KernelDistSQLStatementParser.SetDistVariableContext ctx) {
        return new SetDistVariableStatement(this.getIdentifierValue((ParseTree)ctx.variableName()), this.getIdentifierValue((ParseTree)ctx.variableValue()));
    }

    @Override
    public ASTNode visitShowLogicalTables(KernelDistSQLStatementParser.ShowLogicalTablesContext ctx) {
        return new ShowLogicalTablesStatement(null != ctx.FULL(), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), null == ctx.showLike() ? null : this.getIdentifierValue((ParseTree)ctx.showLike().likePattern()));
    }

    @Override
    public ASTNode visitShowDistVariable(KernelDistSQLStatementParser.ShowDistVariableContext ctx) {
        return new ShowDistVariableStatement(Objects.requireNonNull(this.getIdentifierValue((ParseTree)ctx.variableName())).toUpperCase());
    }

    @Override
    public ASTNode visitShowDistVariables(KernelDistSQLStatementParser.ShowDistVariablesContext ctx) {
        return new ShowDistVariablesStatement(null == ctx.showLike() ? null : this.getIdentifierValue((ParseTree)ctx.showLike().likePattern()));
    }

    @Override
    public ASTNode visitRefreshDatabaseMetadata(KernelDistSQLStatementParser.RefreshDatabaseMetadataContext ctx) {
        return new RefreshDatabaseMetaDataStatement(null == ctx.databaseName() ? null : this.getIdentifierValue((ParseTree)ctx.databaseName()), null != ctx.FORCE());
    }

    @Override
    public ASTNode visitRefreshTableMetadata(KernelDistSQLStatementParser.RefreshTableMetadataContext ctx) {
        if (null == ctx.refreshScope()) {
            return new RefreshTableMetaDataStatement();
        }
        String storageUnitName = null;
        String schemaName = null;
        String tableName = this.getIdentifierValue((ParseTree)ctx.refreshScope().tableName());
        if (null != ctx.refreshScope().fromSegment()) {
            KernelDistSQLStatementParser.FromSegmentContext fromSegment = ctx.refreshScope().fromSegment();
            storageUnitName = this.getIdentifierValue((ParseTree)fromSegment.storageUnitName());
            schemaName = null == fromSegment.schemaName() ? null : this.getIdentifierValue((ParseTree)fromSegment.schemaName());
        }
        return new RefreshTableMetaDataStatement(tableName, storageUnitName, schemaName);
    }

    @Override
    public ASTNode visitExportDatabaseConfiguration(KernelDistSQLStatementParser.ExportDatabaseConfigurationContext ctx) {
        return new ExportDatabaseConfigurationStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitExportMetaData(KernelDistSQLStatementParser.ExportMetaDataContext ctx) {
        return new ExportMetaDataStatement(null == ctx.filePath() ? null : this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitExportStorageNodes(KernelDistSQLStatementParser.ExportStorageNodesContext ctx) {
        return new ExportStorageNodesStatement(null == ctx.databaseName() ? null : this.getIdentifierValue((ParseTree)ctx.databaseName()), null == ctx.filePath() ? null : this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitConvertYamlConfiguration(KernelDistSQLStatementParser.ConvertYamlConfigurationContext ctx) {
        return new ConvertYamlConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitShowRulesUsedStorageUnit(KernelDistSQLStatementParser.ShowRulesUsedStorageUnitContext ctx) {
        return new ShowRulesUsedStorageUnitStatement(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitImportDatabaseConfiguration(KernelDistSQLStatementParser.ImportDatabaseConfigurationContext ctx) {
        return new ImportDatabaseConfigurationStatement(this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitImportMetaData(KernelDistSQLStatementParser.ImportMetaDataContext ctx) {
        return new ImportMetaDataStatement(null == ctx.metaDataValue() ? null : QuoteCharacter.unwrapText((String)ctx.metaDataValue().getText()), this.getIdentifierValue((ParseTree)ctx.filePath()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(KernelDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.buildProperties(ctx.propertiesDefinition()));
    }

    private Properties buildProperties(KernelDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx) {
            return result;
        }
        for (KernelDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitLockCluster(KernelDistSQLStatementParser.LockClusterContext ctx) {
        return new LockClusterStatement((AlgorithmSegment)this.visitAlgorithmDefinition(ctx.lockStrategy().algorithmDefinition()), Long.valueOf(Long.parseLong(this.getIdentifierValue((ParseTree)ctx.INT_()))));
    }

    @Override
    public ASTNode visitUnlockCluster(KernelDistSQLStatementParser.UnlockClusterContext ctx) {
        return new UnlockClusterStatement(Long.valueOf(Long.parseLong(this.getIdentifierValue((ParseTree)ctx.INT_()))));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitShowPluginImplementations(KernelDistSQLStatementParser.ShowPluginImplementationsContext ctx) {
        return new ShowPluginsStatement("COMMON", this.getIdentifierValue((ParseTree)ctx.pluginClass()));
    }

    @Override
    public ASTNode visitShowKeyGenerateAlgorithmPlugins(KernelDistSQLStatementParser.ShowKeyGenerateAlgorithmPluginsContext ctx) {
        return new ShowPluginsStatement("KEY_GENERATE_ALGORITHM");
    }

    @Override
    public ASTNode visitShowLoadBalanceAlgorithmPlugins(KernelDistSQLStatementParser.ShowLoadBalanceAlgorithmPluginsContext ctx) {
        return new ShowPluginsStatement("LOAD_BALANCE_ALGORITHM");
    }
}

