/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.decimal;

import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLDecimalBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    private static final int DEC_BYTE_SIZE = 4;
    private static final int DIG_PER_DEC = 9;
    private static final int[] DIG_TO_BYTES = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};

    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        DecimalMetaData decimalMetaData = new DecimalMetaData(columnDef.getColumnMeta());
        return MySQLDecimalBinlogProtocolValue.toDecimal(decimalMetaData, payload.readStringFixByBytes(decimalMetaData.getTotalByteLength()));
    }

    private static BigDecimal toDecimal(DecimalMetaData metaData, byte[] value) {
        boolean positive = 128 == (value[0] & 0x80);
        value[0] = (byte)(value[0] ^ 0x80);
        if (!positive) {
            int i = 0;
            while (i < value.length) {
                int n = i++;
                value[n] = (byte)(value[n] ^ 0xFF);
            }
        }
        BigDecimal integerValue = MySQLDecimalBinlogProtocolValue.decodeIntegerValue(metaData, value);
        BigDecimal scaleValue = MySQLDecimalBinlogProtocolValue.decodeScaleValue(metaData, value);
        BigDecimal result = integerValue.add(scaleValue);
        return positive ? result : result.negate();
    }

    private static BigDecimal decodeIntegerValue(DecimalMetaData metaData, byte[] value) {
        BigDecimal result;
        int offset = DIG_TO_BYTES[metaData.getExtraIntegerSize()];
        BigDecimal bigDecimal = result = offset > 0 ? BigDecimal.valueOf(MySQLDecimalBinlogProtocolValue.readFixedLengthIntBE(value, 0, offset)) : BigDecimal.ZERO;
        while (offset < metaData.getIntegerByteLength()) {
            int i = MySQLDecimalBinlogProtocolValue.readFixedLengthIntBE(value, offset, 4);
            result = result.movePointRight(9).add(BigDecimal.valueOf(i));
            offset += 4;
        }
        return result;
    }

    private static BigDecimal decodeScaleValue(DecimalMetaData metaData, byte[] value) {
        BigDecimal result = BigDecimal.ZERO;
        int shift = 0;
        int offset = metaData.getIntegerByteLength();
        int scale = metaData.getScale();
        while (shift + 9 <= scale) {
            result = result.add(BigDecimal.valueOf(MySQLDecimalBinlogProtocolValue.readFixedLengthIntBE(value, offset, 4)).movePointLeft(shift + 9));
            shift += 9;
            offset += 4;
        }
        if (shift < scale) {
            result = result.add(BigDecimal.valueOf(MySQLDecimalBinlogProtocolValue.readFixedLengthIntBE(value, offset, DIG_TO_BYTES[scale - shift])).movePointLeft(scale));
        }
        return result;
    }

    private static int readFixedLengthIntBE(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i = offset; i < offset + length; ++i) {
            result = result << 8 | (short)(0xFF & bytes[i]);
        }
        return result;
    }

    private static final class DecimalMetaData {
        private final int scale;
        private final int extraIntegerSize;
        private final int integerByteLength;
        private final int totalByteLength;

        private DecimalMetaData(int metaData) {
            this.scale = metaData & 0xFF;
            int precision = metaData >> 8;
            int integer = precision - this.scale;
            int fullIntegerSize = integer / 9;
            this.extraIntegerSize = integer - fullIntegerSize * 9;
            this.integerByteLength = (fullIntegerSize << 2) + DIG_TO_BYTES[this.extraIntegerSize];
            int fullScaleSize = this.scale / 9;
            int extraScaleSize = this.scale - fullScaleSize * 9;
            this.totalByteLength = this.integerByteLength + (fullScaleSize << 2) + DIG_TO_BYTES[extraScaleSize];
        }

        @Generated
        public int getScale() {
            return this.scale;
        }

        @Generated
        public int getExtraIntegerSize() {
            return this.extraIntegerSize;
        }

        @Generated
        public int getIntegerByteLength() {
            return this.integerByteLength;
        }

        @Generated
        public int getTotalByteLength() {
            return this.totalByteLength;
        }
    }
}

