/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ViewMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String VIEWS_NODE = "views";
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";
    private static final String VIEWS_PATTERN = "/([\\w\\-]+)/schemas/([\\w\\-]+)/views";
    private static final String ACTIVE_VERSION_SUFFIX = "/([\\w\\-]+)/active_version";
    private static final String VIEW_SUFFIX = "/([\\w\\-]+)$";

    public static String getMetaDataViewsNode(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ViewMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE);
    }

    public static String getViewActiveVersionNode(String databaseName, String schemaName, String viewName) {
        return String.join((CharSequence)"/", ViewMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE, viewName, ACTIVE_VERSION);
    }

    public static String getViewVersionsNode(String databaseName, String schemaName, String viewName) {
        return String.join((CharSequence)"/", ViewMetaDataNode.getMetaDataNode(), databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE, viewName, VERSIONS);
    }

    public static String getViewVersionNode(String databaseName, String schemaName, String viewName, String version) {
        return String.join((CharSequence)"/", ViewMetaDataNode.getViewVersionsNode(databaseName, schemaName, viewName), version);
    }

    public static String getViewNode(String databaseName, String schemaName, String viewName) {
        return String.join((CharSequence)"/", "", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, VIEWS_NODE, viewName);
    }

    public static Optional<String> getViewNameByActiveVersionNode(String path) {
        Pattern pattern = Pattern.compile(ViewMetaDataNode.getMetaDataNode() + VIEWS_PATTERN + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> getViewName(String path) {
        Pattern pattern = Pattern.compile(ViewMetaDataNode.getMetaDataNode() + VIEWS_PATTERN + VIEW_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static boolean isViewActiveVersionNode(String path) {
        return Pattern.compile(ViewMetaDataNode.getMetaDataNode() + VIEWS_PATTERN + ACTIVE_VERSION_SUFFIX, 2).matcher(path).find();
    }

    public static boolean isViewNode(String path) {
        return Pattern.compile(ViewMetaDataNode.getMetaDataNode() + VIEWS_PATTERN + VIEW_SUFFIX, 2).matcher(path).find();
    }

    private static String getMetaDataNode() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    @Generated
    private ViewMetaDataNode() {
    }
}

