/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class StatesNode {
    private static final String ROOT_NODE = "states";
    private static final String CLUSTER_STATE_NODE = "cluster_state";
    private static final String LISTENER_ASSISTED_NODE = "listener_assisted";

    public static String getClusterStateNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, CLUSTER_STATE_NODE);
    }

    public static String getListenerAssistedNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, LISTENER_ASSISTED_NODE);
    }

    public static Optional<String> getDatabaseNameByListenerAssistedNodePath(String nodePath) {
        Pattern pattern = Pattern.compile(StatesNode.getListenerAssistedNodePath() + "/(\\w+)$", 2);
        Matcher matcher = pattern.matcher(nodePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static String getDatabaseNameListenerAssistedNodePath(String databaseName) {
        return String.join((CharSequence)"/", "", ROOT_NODE, LISTENER_ASSISTED_NODE, databaseName);
    }

    @Generated
    private StatesNode() {
    }
}

