/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLNoDataPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLBindCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLBatchedStatementsExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLServerPreparedStatement;

public final class PostgreSQLAggregatedBatchedStatementsCommandExecutor
implements CommandExecutor {
    private final ConnectionSession connectionSession;
    private final List<PostgreSQLCommandPacket> packets;

    public Collection<DatabasePacket> execute() throws SQLException {
        PostgreSQLServerPreparedStatement preparedStatement = this.getPreparedStatement();
        PostgreSQLBatchedStatementsExecutor executor = new PostgreSQLBatchedStatementsExecutor(this.connectionSession, preparedStatement, this.readParameterSets(preparedStatement.getParameterTypes()));
        ArrayList<DatabasePacket> result = new ArrayList<DatabasePacket>(this.packets.size());
        int totalInserted = executor.executeBatch();
        int executePacketCount = this.executePacketCount();
        for (PostgreSQLCommandPacket each : this.packets) {
            if (each instanceof PostgreSQLComBindPacket) {
                result.add((DatabasePacket)PostgreSQLBindCompletePacket.getInstance());
            }
            if (each instanceof PostgreSQLComDescribePacket) {
                result.add((DatabasePacket)preparedStatement.describeRows().orElseGet(PostgreSQLNoDataPacket::getInstance));
            }
            if (!(each instanceof PostgreSQLComExecutePacket)) continue;
            String tag = PostgreSQLCommand.valueOf(preparedStatement.getSqlStatementContext().getSqlStatement().getClass()).orElse(PostgreSQLCommand.INSERT).getTag();
            result.add((DatabasePacket)new PostgreSQLCommandCompletePacket(tag, 0 == executePacketCount ? 1L : (long)(totalInserted / executePacketCount)));
        }
        return result;
    }

    private PostgreSQLServerPreparedStatement getPreparedStatement() {
        PostgreSQLComBindPacket bindPacket = (PostgreSQLComBindPacket)this.packets.get(0);
        return (PostgreSQLServerPreparedStatement)this.connectionSession.getServerPreparedStatementRegistry().getPreparedStatement((Object)bindPacket.getStatementId());
    }

    private List<List<Object>> readParameterSets(List<PostgreSQLColumnType> parameterTypes) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (PostgreSQLCommandPacket each : this.packets) {
            if (!(each instanceof PostgreSQLComBindPacket)) continue;
            result.add(((PostgreSQLComBindPacket)each).readParameters(parameterTypes));
        }
        return result;
    }

    private int executePacketCount() {
        int result = 0;
        for (PostgreSQLCommandPacket each : this.packets) {
            if (!(each instanceof PostgreSQLComExecutePacket)) continue;
            ++result;
        }
        return result;
    }

    @Generated
    public PostgreSQLAggregatedBatchedStatementsCommandExecutor(ConnectionSession connectionSession, List<PostgreSQLCommandPacket> packets) {
        this.connectionSession = connectionSession;
        this.packets = packets;
    }
}

