/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeData;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeDataSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.instance.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.instance.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class ComputeNodeOnlineDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return ComputeNode.getOnlineInstanceNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        return this.createInstanceEvent(event);
    }

    private Optional<DispatchEvent> createInstanceEvent(DataChangedEvent event) {
        Matcher matcher = this.getInstanceOnlinePathMatcher(event.getKey());
        if (!matcher.find()) {
            return Optional.empty();
        }
        ComputeNodeData computeNodeData = new YamlComputeNodeDataSwapper().swapToObject((YamlComputeNodeData)YamlEngine.unmarshal((String)event.getValue(), YamlComputeNodeData.class));
        InstanceMetaData instanceMetaData = InstanceMetaDataFactory.create((String)matcher.group(2), (InstanceType)InstanceType.valueOf((String)matcher.group(1).toUpperCase()), (String)computeNodeData.getAttribute(), (String)computeNodeData.getVersion());
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            return Optional.of(new InstanceOnlineEvent(instanceMetaData));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new InstanceOfflineEvent(instanceMetaData));
        }
        return Optional.empty();
    }

    private Matcher getInstanceOnlinePathMatcher(String onlineInstancePath) {
        return Pattern.compile(ComputeNode.getOnlineInstanceNodePath() + "/([\\S]+)/([\\S]+)$", 2).matcher(onlineInstancePath);
    }
}

