/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.algorithm.keygen.core.KeyGenerateAlgorithm;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContextAware;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.cache.ShardingCache;
import org.apache.shardingsphere.sharding.exception.metadata.ShardingTableRuleNotFoundException;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.rule.attribute.ShardingDataNodeRuleAttribute;
import org.apache.shardingsphere.sharding.rule.attribute.ShardingTableNamesRuleAttribute;
import org.apache.shardingsphere.sharding.rule.checker.ShardingRuleChecker;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAuditAlgorithm;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.ExpressionExtractUtils;

public final class ShardingRule
implements DatabaseRule {
    private final ShardingRuleConfiguration configuration;
    private final Collection<String> dataSourceNames;
    private final Map<String, ShardingAlgorithm> shardingAlgorithms = new CaseInsensitiveMap();
    private final Map<String, KeyGenerateAlgorithm> keyGenerators = new CaseInsensitiveMap();
    private final Map<String, ShardingAuditAlgorithm> auditors = new CaseInsensitiveMap();
    private final Map<String, ShardingTable> shardingTables = new CaseInsensitiveMap();
    private final Map<String, BindingTableRule> bindingTableRules = new CaseInsensitiveMap();
    private final ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig;
    private final ShardingStrategyConfiguration defaultTableShardingStrategyConfig;
    private final ShardingAuditStrategyConfiguration defaultAuditStrategy;
    private final KeyGenerateAlgorithm defaultKeyGenerateAlgorithm;
    private final String defaultShardingColumn;
    private final ShardingCache shardingCache;
    private final RuleAttributes attributes;
    private final ShardingRuleChecker shardingRuleChecker = new ShardingRuleChecker(this);

    public ShardingRule(ShardingRuleConfiguration ruleConfig, Map<String, DataSource> dataSources, ComputeNodeInstanceContext computeNodeInstanceContext) {
        this.configuration = ruleConfig;
        this.dataSourceNames = this.getDataSourceNames(ruleConfig.getTables(), ruleConfig.getAutoTables(), dataSources.keySet());
        ruleConfig.getShardingAlgorithms().forEach((key, value) -> this.shardingAlgorithms.put((String)key, (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)value.getType(), (Properties)value.getProps())));
        ruleConfig.getKeyGenerators().forEach((key, value) -> this.keyGenerators.put((String)key, (KeyGenerateAlgorithm)TypedSPILoader.getService(KeyGenerateAlgorithm.class, (Object)value.getType(), (Properties)value.getProps())));
        ruleConfig.getAuditors().forEach((key, value) -> this.auditors.put((String)key, (ShardingAuditAlgorithm)TypedSPILoader.getService(ShardingAuditAlgorithm.class, (Object)value.getType(), (Properties)value.getProps())));
        this.shardingTables.putAll(this.createShardingTables(ruleConfig.getTables(), ruleConfig.getDefaultKeyGenerateStrategy()));
        this.shardingTables.putAll(this.createShardingAutoTables(ruleConfig.getAutoTables(), ruleConfig.getDefaultKeyGenerateStrategy()));
        this.bindingTableRules.putAll(this.createBindingTableRules(ruleConfig.getBindingTableGroups()));
        this.defaultDatabaseShardingStrategyConfig = this.createDefaultDatabaseShardingStrategyConfiguration(ruleConfig);
        this.defaultTableShardingStrategyConfig = this.createDefaultTableShardingStrategyConfiguration(ruleConfig);
        this.defaultAuditStrategy = null == ruleConfig.getDefaultAuditStrategy() ? new ShardingAuditStrategyConfiguration(Collections.emptyList(), true) : ruleConfig.getDefaultAuditStrategy();
        this.defaultKeyGenerateAlgorithm = null == ruleConfig.getDefaultKeyGenerateStrategy() ? (KeyGenerateAlgorithm)TypedSPILoader.getService(KeyGenerateAlgorithm.class, null) : this.keyGenerators.get(ruleConfig.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        this.defaultShardingColumn = ruleConfig.getDefaultShardingColumn();
        this.keyGenerators.values().stream().filter(ComputeNodeInstanceContextAware.class::isInstance).forEach(each -> ((ComputeNodeInstanceContextAware)each).setComputeNodeInstanceContext(computeNodeInstanceContext));
        if (this.defaultKeyGenerateAlgorithm instanceof ComputeNodeInstanceContextAware && -1 == computeNodeInstanceContext.getWorkerId()) {
            ((ComputeNodeInstanceContextAware)this.defaultKeyGenerateAlgorithm).setComputeNodeInstanceContext(computeNodeInstanceContext);
        }
        this.shardingCache = null == ruleConfig.getShardingCache() ? null : new ShardingCache(ruleConfig.getShardingCache(), this);
        this.attributes = new RuleAttributes(new RuleAttribute[]{new ShardingDataNodeRuleAttribute(this.shardingTables), new ShardingTableNamesRuleAttribute(this.shardingTables.values())});
        this.shardingRuleChecker.check(ruleConfig);
    }

    private ShardingStrategyConfiguration createDefaultDatabaseShardingStrategyConfiguration(ShardingRuleConfiguration ruleConfig) {
        Optional.ofNullable(ruleConfig.getDefaultDatabaseShardingStrategy()).ifPresent(optional -> this.checkManualShardingAlgorithm(optional.getShardingAlgorithmName(), "default"));
        return null == ruleConfig.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : ruleConfig.getDefaultDatabaseShardingStrategy();
    }

    private ShardingStrategyConfiguration createDefaultTableShardingStrategyConfiguration(ShardingRuleConfiguration ruleConfig) {
        Optional.ofNullable(ruleConfig.getDefaultTableShardingStrategy()).ifPresent(optional -> this.checkManualShardingAlgorithm(optional.getShardingAlgorithmName(), "default"));
        return null == ruleConfig.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : ruleConfig.getDefaultTableShardingStrategy();
    }

    private Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty() && autoTableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingTableRuleConfiguration)each)));
        autoTableRuleConfigs.forEach(each -> result.addAll(this.getDataSourceNames((ShardingAutoTableRuleConfiguration)each)));
        return result;
    }

    private Collection<String> getDataSourceNames(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        List actualDataSources = InlineExpressionParserFactory.newInstance((String)shardingAutoTableRuleConfig.getActualDataSources()).splitAndEvaluate();
        return new HashSet<String>(actualDataSources);
    }

    private Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        List actualDataNodes = InlineExpressionParserFactory.newInstance((String)shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate();
        return actualDataNodes.stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private Map<String, ShardingTable> createShardingTables(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return (Map)tableRuleConfigs.stream().map(each -> this.createShardingTable((ShardingTableRuleConfiguration)each, defaultKeyGenerateStrategyConfig)).collect(Collectors.toMap(ShardingTable::getLogicTable, Function.identity(), (oldValue, currentValue) -> oldValue, CaseInsensitiveMap::new));
    }

    private ShardingTable createShardingTable(ShardingTableRuleConfiguration tableRuleConfig, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        Optional.ofNullable(tableRuleConfig.getDatabaseShardingStrategy()).ifPresent(optional -> this.checkManualShardingAlgorithm(optional.getShardingAlgorithmName(), tableRuleConfig.getLogicTable()));
        Optional.ofNullable(tableRuleConfig.getTableShardingStrategy()).ifPresent(optional -> this.checkManualShardingAlgorithm(optional.getShardingAlgorithmName(), tableRuleConfig.getLogicTable()));
        return new ShardingTable(tableRuleConfig, this.dataSourceNames, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private void checkManualShardingAlgorithm(String shardingAlgorithmName, String logicTable) {
        ShardingAlgorithm shardingAlgorithm = this.shardingAlgorithms.get(shardingAlgorithmName);
        ShardingSpherePreconditions.checkState((!(shardingAlgorithm instanceof ShardingAutoTableAlgorithm) ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "`%s` tables sharding configuration can not use auto sharding algorithm.", new Object[]{logicTable}));
    }

    private Map<String, ShardingTable> createShardingAutoTables(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return (Map)autoTableRuleConfigs.stream().map(each -> this.createShardingAutoTable(defaultKeyGenerateStrategyConfig, (ShardingAutoTableRuleConfiguration)each)).collect(Collectors.toMap(ShardingTable::getLogicTable, Function.identity(), (oldValue, currentValue) -> oldValue, CaseInsensitiveMap::new));
    }

    private ShardingTable createShardingAutoTable(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig) {
        this.checkAutoShardingAlgorithm(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName(), autoTableRuleConfig.getLogicTable());
        ShardingAlgorithm shardingAlgorithm = this.shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        return new ShardingTable(autoTableRuleConfig, this.dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, this.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private void checkAutoShardingAlgorithm(String shardingAlgorithmName, String logicTable) {
        ShardingAlgorithm shardingAlgorithm = this.shardingAlgorithms.get(shardingAlgorithmName);
        ShardingSpherePreconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "`%s` autoTables sharding configuration must use auto sharding algorithm.", new Object[]{logicTable}));
    }

    private String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private Map<String, BindingTableRule> createBindingTableRules(Collection<ShardingTableReferenceRuleConfiguration> bindingTableGroups) {
        LinkedHashMap<String, BindingTableRule> result = new LinkedHashMap<String, BindingTableRule>();
        for (ShardingTableReferenceRuleConfiguration each : bindingTableGroups) {
            BindingTableRule bindingTableRule = this.createBindingTableRule(each.getReference());
            for (String logicTable : bindingTableRule.getAllLogicTables()) {
                result.put(logicTable, bindingTableRule);
            }
        }
        return result;
    }

    private BindingTableRule createBindingTableRule(String bindingTableGroup) {
        Map shardingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)bindingTableGroup).stream().map(this::getShardingTable).collect(Collectors.toMap(ShardingTable::getLogicTable, Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        BindingTableRule result = new BindingTableRule();
        result.getShardingTables().putAll(shardingTables);
        return result;
    }

    public ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(ShardingTable shardingTable) {
        return this.getDatabaseShardingStrategyConfiguration(shardingTable, this.defaultDatabaseShardingStrategyConfig);
    }

    private ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(ShardingTable shardingTable, ShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig) {
        return null == shardingTable.getDatabaseShardingStrategyConfig() ? defaultDatabaseShardingStrategyConfig : shardingTable.getDatabaseShardingStrategyConfig();
    }

    public ShardingStrategyConfiguration getTableShardingStrategyConfiguration(ShardingTable shardingTable) {
        return this.getTableShardingStrategyConfiguration(shardingTable, this.defaultTableShardingStrategyConfig);
    }

    private ShardingStrategyConfiguration getTableShardingStrategyConfiguration(ShardingTable shardingTable, ShardingStrategyConfiguration defaultTableShardingStrategyConfig) {
        return null == shardingTable.getTableShardingStrategyConfig() ? defaultTableShardingStrategyConfig : shardingTable.getTableShardingStrategyConfig();
    }

    public ShardingAuditStrategyConfiguration getAuditStrategyConfiguration(ShardingTable shardingTable) {
        return null == shardingTable.getAuditStrategyConfig() ? this.defaultAuditStrategy : shardingTable.getAuditStrategyConfig();
    }

    public Optional<ShardingTable> findShardingTable(String logicTableName) {
        if (Strings.isNullOrEmpty((String)logicTableName) || !this.shardingTables.containsKey(logicTableName)) {
            return Optional.empty();
        }
        return Optional.of(this.shardingTables.get(logicTableName));
    }

    public Optional<ShardingTable> findShardingTableByActualTable(String actualTableName) {
        for (ShardingTable each : this.shardingTables.values()) {
            if (!each.isExisted(actualTableName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public ShardingTable getShardingTable(String logicTableName) {
        return this.findShardingTable(logicTableName).orElseThrow(() -> new ShardingTableRuleNotFoundException(Collections.singleton(logicTableName)));
    }

    public boolean isAllBindingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTableNames);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(bindingTableRule.get().getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTableNames);
    }

    public boolean isAllBindingTables(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext, Collection<String> logicTableNames) {
        if (!(sqlStatementContext instanceof SelectStatementContext) || !((SelectStatementContext)sqlStatementContext).isContainsJoinQuery()) {
            return this.isAllBindingTables(logicTableNames);
        }
        if (!this.isAllBindingTables(logicTableNames)) {
            return false;
        }
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        SelectStatementContext select = (SelectStatementContext)sqlStatementContext;
        ShardingSphereSchema schema = select.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
        return this.isJoinConditionContainsShardingColumns(schema, select, logicTableNames, select.getWhereSegments());
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTableName) {
        return Optional.ofNullable(this.bindingTableRules.get(logicTableName));
    }

    public boolean isAllShardingTables(Collection<String> logicTableNames) {
        if (logicTableNames.isEmpty()) {
            return false;
        }
        for (String each : logicTableNames) {
            if (this.isShardingTable(each)) continue;
            return false;
        }
        return true;
    }

    public boolean isShardingTable(String logicTableName) {
        return this.shardingTables.containsKey(logicTableName);
    }

    public boolean isAllTablesInSameDataSource(Collection<String> logicTableNames) {
        Collection dataSourceNames = logicTableNames.stream().map(this.shardingTables::get).filter(Objects::nonNull).flatMap(each -> each.getActualDataSourceNames().stream()).collect(Collectors.toSet());
        return 1 == dataSourceNames.size();
    }

    public boolean containsShardingTable(Collection<String> logicTableNames) {
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> findShardingColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.shardingTables.get(tableName)).flatMap(optional -> this.findShardingColumn((ShardingTable)optional, columnName));
    }

    private Optional<String> findShardingColumn(ShardingTable shardingTable, String columnName) {
        Optional<String> databaseShardingColumn = this.findShardingColumn(this.getDatabaseShardingStrategyConfiguration(shardingTable), columnName);
        if (databaseShardingColumn.isPresent()) {
            return databaseShardingColumn;
        }
        return this.findShardingColumn(this.getTableShardingStrategyConfiguration(shardingTable), columnName);
    }

    private Optional<String> findShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String columnName) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            String shardingColumn = null == ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn() ? this.defaultShardingColumn : ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
            return shardingColumn.equalsIgnoreCase(columnName) ? Optional.of(shardingColumn) : Optional.empty();
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            List shardingColumns = Splitter.on((String)",").trimResults().splitToList((CharSequence)((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns());
            for (String each : shardingColumns) {
                if (!each.equalsIgnoreCase(columnName)) continue;
                return Optional.of(each);
            }
        }
        return Optional.empty();
    }

    public boolean isGenerateKeyColumn(String columnName, String tableName) {
        return Optional.ofNullable(this.shardingTables.get(tableName)).filter(each -> this.isGenerateKeyColumn((ShardingTable)each, columnName)).isPresent();
    }

    private boolean isGenerateKeyColumn(ShardingTable shardingTable, String columnName) {
        Optional<String> generateKeyColumn = shardingTable.getGenerateKeyColumn();
        return generateKeyColumn.isPresent() && generateKeyColumn.get().equalsIgnoreCase(columnName);
    }

    public Optional<String> findGenerateKeyColumnName(String logicTableName) {
        return Optional.ofNullable(this.shardingTables.get(logicTableName)).filter(each -> each.getGenerateKeyColumn().isPresent()).flatMap(ShardingTable::getGenerateKeyColumn);
    }

    public Collection<? extends Comparable<?>> generateKeys(AlgorithmSQLContext algorithmSQLContext, int keyGenerateCount) {
        return this.getKeyGenerateAlgorithm(algorithmSQLContext.getTableName()).generateKeys(algorithmSQLContext, keyGenerateCount);
    }

    public boolean isSupportAutoIncrement(String logicTableName) {
        return this.getKeyGenerateAlgorithm(logicTableName).isSupportAutoIncrement();
    }

    private KeyGenerateAlgorithm getKeyGenerateAlgorithm(String logicTableName) {
        ShardingTable shardingTable = this.getShardingTable(logicTableName);
        return null == shardingTable.getKeyGeneratorName() ? this.defaultKeyGenerateAlgorithm : this.keyGenerators.get(shardingTable.getKeyGeneratorName());
    }

    public DataNode getDataNode(String logicTableName) {
        ShardingTable shardingTable = this.getShardingTable(logicTableName);
        return shardingTable.getActualDataNodes().get(0);
    }

    public Collection<String> getShardingLogicTableNames(Collection<String> logicTableNames) {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : logicTableNames) {
            if (!this.isShardingTable(each)) continue;
            result.add(each);
        }
        return result;
    }

    public Collection<String> getShardingRuleTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(this::isShardingTable).collect(Collectors.toList());
    }

    public Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        return this.findBindingTableRule(logicTable).map(optional -> optional.getLogicAndActualTables(dataSourceName, logicTable, actualTable, availableLogicBindingTables)).orElseGet(Collections::emptyMap);
    }

    public boolean isShardingCacheEnabled() {
        return null != this.shardingCache;
    }

    private boolean isJoinConditionContainsShardingColumns(ShardingSphereSchema schema, SelectStatementContext select, Collection<String> tableNames, Collection<WhereSegment> whereSegments) {
        HashSet<String> databaseJoinConditionTables = new HashSet<String>(tableNames.size(), 1.0f);
        HashSet<String> tableJoinConditionTables = new HashSet<String>(tableNames.size(), 1.0f);
        for (WhereSegment each : whereSegments) {
            Collection andPredicates = ExpressionExtractUtils.getAndPredicates((ExpressionSegment)each.getExpr());
            if (andPredicates.size() > 1) {
                return false;
            }
            for (AndPredicate andPredicate : andPredicates) {
                databaseJoinConditionTables.addAll(this.getJoinConditionTables(schema, select, andPredicate.getPredicates(), true));
                tableJoinConditionTables.addAll(this.getJoinConditionTables(schema, select, andPredicate.getPredicates(), false));
            }
        }
        ShardingTable shardingTable = this.getShardingTable(tableNames.iterator().next());
        boolean containsDatabaseShardingColumns = !(this.getDatabaseShardingStrategyConfiguration(shardingTable) instanceof StandardShardingStrategyConfiguration) || databaseJoinConditionTables.containsAll(tableNames);
        boolean containsTableShardingColumns = !(this.getTableShardingStrategyConfiguration(shardingTable) instanceof StandardShardingStrategyConfiguration) || tableJoinConditionTables.containsAll(tableNames);
        return containsDatabaseShardingColumns && containsTableShardingColumns;
    }

    private Collection<String> getJoinConditionTables(ShardingSphereSchema schema, SelectStatementContext select, Collection<ExpressionSegment> predicates, boolean isDatabaseJoinCondition) {
        LinkedList<String> result = new LinkedList<String>();
        for (ExpressionSegment each : predicates) {
            ShardingStrategyConfiguration rightConfig;
            if (!this.isJoinConditionExpression(each)) continue;
            ColumnSegment leftColumn = (ColumnSegment)((BinaryOperationExpression)each).getLeft();
            ColumnSegment rightColumn = (ColumnSegment)((BinaryOperationExpression)each).getRight();
            Map columnExpressionTableNames = select.getTablesContext().findTableNames(Arrays.asList(leftColumn, rightColumn), schema);
            Optional<ShardingTable> leftShardingTable = this.findShardingTable((String)columnExpressionTableNames.get(leftColumn.getExpression()));
            Optional<ShardingTable> rightShardingTable = this.findShardingTable((String)columnExpressionTableNames.get(rightColumn.getExpression()));
            if (!leftShardingTable.isPresent() || !rightShardingTable.isPresent()) continue;
            ShardingStrategyConfiguration leftConfig = isDatabaseJoinCondition ? this.getDatabaseShardingStrategyConfiguration(leftShardingTable.get()) : this.getTableShardingStrategyConfiguration(leftShardingTable.get());
            ShardingStrategyConfiguration shardingStrategyConfiguration = rightConfig = isDatabaseJoinCondition ? this.getDatabaseShardingStrategyConfiguration(rightShardingTable.get()) : this.getTableShardingStrategyConfiguration(rightShardingTable.get());
            if (!this.findShardingColumn(leftConfig, leftColumn.getIdentifier().getValue()).isPresent() || !this.findShardingColumn(rightConfig, rightColumn.getIdentifier().getValue()).isPresent()) continue;
            result.add((String)columnExpressionTableNames.get(leftColumn.getExpression()));
            result.add((String)columnExpressionTableNames.get(rightColumn.getExpression()));
        }
        return result;
    }

    private boolean isJoinConditionExpression(ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            return false;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        return binaryExpression.getLeft() instanceof ColumnSegment && binaryExpression.getRight() instanceof ColumnSegment && "=".equals(binaryExpression.getOperator());
    }

    @Generated
    public ShardingRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, ShardingAlgorithm> getShardingAlgorithms() {
        return this.shardingAlgorithms;
    }

    @Generated
    public Map<String, KeyGenerateAlgorithm> getKeyGenerators() {
        return this.keyGenerators;
    }

    @Generated
    public Map<String, ShardingAuditAlgorithm> getAuditors() {
        return this.auditors;
    }

    @Generated
    public Map<String, ShardingTable> getShardingTables() {
        return this.shardingTables;
    }

    @Generated
    public Map<String, BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultDatabaseShardingStrategyConfig() {
        return this.defaultDatabaseShardingStrategyConfig;
    }

    @Generated
    public ShardingStrategyConfiguration getDefaultTableShardingStrategyConfig() {
        return this.defaultTableShardingStrategyConfig;
    }

    @Generated
    public ShardingAuditStrategyConfiguration getDefaultAuditStrategy() {
        return this.defaultAuditStrategy;
    }

    @Generated
    public KeyGenerateAlgorithm getDefaultKeyGenerateAlgorithm() {
        return this.defaultKeyGenerateAlgorithm;
    }

    @Generated
    public String getDefaultShardingColumn() {
        return this.defaultShardingColumn;
    }

    @Generated
    public ShardingCache getShardingCache() {
        return this.shardingCache;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public ShardingRuleChecker getShardingRuleChecker() {
        return this.shardingRuleChecker;
    }
}

