/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.readwritesplitting.route.qualified.QualifiedReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.route.qualified.type.QualifiedReadwriteSplittingPrimaryDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.route.qualified.type.QualifiedReadwriteSplittingTransactionalDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.route.standard.StandardReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;

public final class ReadwriteSplittingDataSourceRouter {
    private final ReadwriteSplittingDataSourceGroupRule rule;
    private final Collection<QualifiedReadwriteSplittingDataSourceRouter> qualifiedRouters;

    public ReadwriteSplittingDataSourceRouter(ReadwriteSplittingDataSourceGroupRule rule, ConnectionContext connectionContext) {
        this.rule = rule;
        this.qualifiedRouters = Arrays.asList(new QualifiedReadwriteSplittingPrimaryDataSourceRouter(), new QualifiedReadwriteSplittingTransactionalDataSourceRouter(connectionContext));
    }

    public String route(SQLStatementContext sqlStatementContext, HintValueContext hintValueContext) {
        for (QualifiedReadwriteSplittingDataSourceRouter each : this.qualifiedRouters) {
            if (!each.isQualified(sqlStatementContext, this.rule, hintValueContext)) continue;
            return each.route(this.rule);
        }
        return new StandardReadwriteSplittingDataSourceRouter().route(this.rule);
    }
}

