/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class SchemaMetaDataManager {
    private final AtomicReference<MetaDataContexts> metaDataContexts;
    private final MetaDataPersistService metaDataPersistService;

    public SchemaMetaDataManager(AtomicReference<MetaDataContexts> metaDataContexts, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public synchronized void addDatabase(String databaseName) {
        if (this.metaDataContexts.get().getMetaData().containsDatabase(databaseName)) {
            return;
        }
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(Collections.emptyMap(), (ConfigurationProperties)this.metaDataContexts.get().getMetaData().getProps());
        this.metaDataContexts.get().getMetaData().addDatabase(databaseName, protocolType, this.metaDataContexts.get().getMetaData().getProps());
        this.metaDataContexts.set(MetaDataContextsFactory.create(this.metaDataPersistService, this.metaDataContexts.get().getMetaData()));
    }

    public synchronized void dropDatabase(String databaseName) {
        if (!this.metaDataContexts.get().getMetaData().containsDatabase(databaseName)) {
            return;
        }
        this.metaDataContexts.get().getMetaData().dropDatabase(this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getName());
    }

    public synchronized void addSchema(String databaseName, String schemaName) {
        ShardingSphereMetaData metaData = this.metaDataContexts.get().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        if (database.containsSchema(schemaName)) {
            return;
        }
        database.addSchema(schemaName, new ShardingSphereSchema(schemaName));
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public synchronized void dropSchema(String databaseName, String schemaName) {
        ShardingSphereMetaData metaData = this.metaDataContexts.get().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        if (!database.containsSchema(schemaName)) {
            return;
        }
        database.dropSchema(schemaName);
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public synchronized void alterSchema(String databaseName, String schemaName, ShardingSphereTable toBeChangedTable, ShardingSphereView toBeChangedView) {
        ShardingSphereMetaData metaData = this.metaDataContexts.get().getMetaData();
        if (!metaData.getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        Optional.ofNullable(toBeChangedTable).ifPresent(optional -> this.alterTable(databaseName, schemaName, (ShardingSphereTable)optional));
        Optional.ofNullable(toBeChangedView).ifPresent(optional -> this.alterView(databaseName, schemaName, (ShardingSphereView)optional));
        if (null != toBeChangedTable || null != toBeChangedView) {
            metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        }
    }

    public synchronized void alterSchema(String databaseName, String schemaName, String toBeDeletedTableName, String toBeDeletedViewName) {
        ShardingSphereMetaData metaData = this.metaDataContexts.get().getMetaData();
        if (!metaData.getDatabase(databaseName).containsSchema(schemaName)) {
            return;
        }
        Optional.ofNullable(toBeDeletedTableName).ifPresent(optional -> this.dropTable(databaseName, schemaName, (String)optional));
        Optional.ofNullable(toBeDeletedViewName).ifPresent(optional -> this.dropView(databaseName, schemaName, (String)optional));
        if (!Strings.isNullOrEmpty((String)toBeDeletedTableName) || !Strings.isNullOrEmpty((String)toBeDeletedViewName)) {
            metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        }
    }

    private void alterTable(String databaseName, String schemaName, ShardingSphereTable beBoChangedTable) {
        ShardingSphereDatabase database = this.metaDataContexts.get().getMetaData().getDatabase(databaseName);
        if (TableRefreshUtils.isSingleTable(beBoChangedTable.getName(), database)) {
            database.reloadRules();
        }
        database.getSchema(schemaName).putTable(beBoChangedTable.getName(), beBoChangedTable);
    }

    private void alterView(String databaseName, String schemaName, ShardingSphereView beBoChangedView) {
        ShardingSphereDatabase database = this.metaDataContexts.get().getMetaData().getDatabase(databaseName);
        if (TableRefreshUtils.isSingleTable(beBoChangedView.getName(), database)) {
            database.reloadRules();
        }
        database.getSchema(schemaName).putView(beBoChangedView.getName(), beBoChangedView);
    }

    private void dropTable(String databaseName, String schemaName, String toBeDeletedTableName) {
        this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getSchema(schemaName).removeTable(toBeDeletedTableName);
        this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.remove(schemaName, toBeDeletedTableName));
    }

    private void dropView(String databaseName, String schemaName, String toBeDeletedViewName) {
        this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getSchema(schemaName).removeView(toBeDeletedViewName);
        this.metaDataContexts.get().getMetaData().getDatabase(databaseName).getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.remove(schemaName, toBeDeletedViewName));
    }
}

