/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListener;
import org.apache.shardingsphere.mode.metadata.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.persist.PersistServiceFacade;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.apache.shardingsphere.mode.state.StateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextManager.class);
    private final AtomicReference<MetaDataContexts> metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ExecutorEngine executorEngine;
    private final StateContext stateContext;
    private final PersistServiceFacade persistServiceFacade;
    private final MetaDataContextManager metaDataContextManager;

    public ContextManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository) {
        this.metaDataContexts = new AtomicReference<MetaDataContexts>(metaDataContexts);
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.metaDataContextManager = new MetaDataContextManager(this.metaDataContexts, computeNodeInstanceContext, repository);
        this.persistServiceFacade = new PersistServiceFacade(repository, computeNodeInstanceContext.getModeConfiguration(), this.metaDataContextManager);
        this.stateContext = new StateContext(this.persistServiceFacade.getStatePersistService().load());
        this.executorEngine = ExecutorEngine.createExecutorEngineWithSize((int)((Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE)));
        for (ContextManagerLifecycleListener each : ShardingSphereServiceLoader.getServiceInstances(ContextManagerLifecycleListener.class)) {
            each.onInitialized(this);
        }
    }

    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts.get();
    }

    public void renewMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts.set(metaDataContexts);
    }

    public ShardingSphereDatabase getDatabase(String name) {
        ShardingSpherePreconditions.checkNotEmpty((String)name, NoDatabaseSelectedException::new);
        ShardingSphereMetaData metaData = this.getMetaDataContexts().getMetaData();
        ShardingSpherePreconditions.checkState((boolean)metaData.containsDatabase(name), () -> new UnknownDatabaseException(name));
        return metaData.getDatabase(name);
    }

    public Map<String, StorageUnit> getStorageUnits(String databaseName) {
        return this.getDatabase(databaseName).getResourceMetaData().getStorageUnits();
    }

    public void reloadSchema(ShardingSphereDatabase database, String schemaName, String dataSourceName) {
        try {
            ShardingSphereSchema reloadedSchema = this.loadSchema(database, schemaName, dataSourceName);
            if (reloadedSchema.getTables().isEmpty()) {
                database.dropSchema(schemaName);
                this.persistServiceFacade.getMetaDataPersistService().getDatabaseMetaDataFacade().getSchema().drop(database.getName(), schemaName);
            } else {
                database.addSchema(schemaName, reloadedSchema);
                this.persistServiceFacade.getMetaDataPersistService().getDatabaseMetaDataFacade().getSchema().alterByRefresh(database.getName(), reloadedSchema);
            }
        }
        catch (SQLException ex) {
            log.error("Reload meta data of database: {} schema: {} with data source: {} failed", new Object[]{database.getName(), schemaName, dataSourceName, ex});
        }
    }

    private ShardingSphereSchema loadSchema(ShardingSphereDatabase database, String schemaName, String dataSourceName) throws SQLException {
        database.reloadRules();
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getProtocolType(), Collections.singletonMap(dataSourceName, ((StorageUnit)database.getResourceMetaData().getStorageUnits().get(dataSourceName)).getStorageType()), Collections.singletonMap(dataSourceName, ((StorageUnit)database.getResourceMetaData().getStorageUnits().get(dataSourceName)).getDataSource()), database.getRuleMetaData().getRules(), this.metaDataContexts.get().getMetaData().getProps(), schemaName);
        ShardingSphereSchema result = (ShardingSphereSchema)GenericSchemaBuilder.build((GenericSchemaBuilderMaterial)material).get(schemaName);
        result.getViews().putAll(this.persistServiceFacade.getMetaDataPersistService().getDatabaseMetaDataFacade().getView().load(database.getName(), schemaName));
        return result;
    }

    public void reloadTable(ShardingSphereDatabase database, String schemaName, String tableName) {
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getProtocolType(), database.getResourceMetaData().getStorageUnits(), database.getRuleMetaData().getRules(), this.metaDataContexts.get().getMetaData().getProps(), schemaName);
        try {
            this.persistTable(database, schemaName, tableName, material);
        }
        catch (SQLException ex) {
            log.error("Reload table: {} meta data of database: {} schema: {} failed", new Object[]{tableName, database.getName(), schemaName, ex});
        }
    }

    public void reloadTable(ShardingSphereDatabase database, String schemaName, String dataSourceName, String tableName) {
        StorageUnit storageUnit = (StorageUnit)database.getResourceMetaData().getStorageUnits().get(dataSourceName);
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getProtocolType(), Collections.singletonMap(dataSourceName, storageUnit.getStorageType()), Collections.singletonMap(dataSourceName, storageUnit.getDataSource()), database.getRuleMetaData().getRules(), this.metaDataContexts.get().getMetaData().getProps(), schemaName);
        try {
            this.persistTable(database, schemaName, tableName, material);
        }
        catch (SQLException ex) {
            log.error("Reload table: {} meta data of database: {} schema: {} with data source: {} failed", new Object[]{tableName, database.getName(), schemaName, dataSourceName, ex});
        }
    }

    private void persistTable(ShardingSphereDatabase database, String schemaName, String tableName, GenericSchemaBuilderMaterial material) throws SQLException {
        ShardingSphereSchema schema = GenericSchemaBuilder.build(Collections.singleton(tableName), (GenericSchemaBuilderMaterial)material).getOrDefault(schemaName, new ShardingSphereSchema(schemaName));
        this.persistServiceFacade.getMetaDataPersistService().getDatabaseMetaDataFacade().getTable().persist(database.getName(), schemaName, Collections.singletonMap(tableName, schema.getTable(tableName)));
    }

    public String getPreSelectedDatabaseName() {
        return InstanceType.JDBC == this.computeNodeInstanceContext.getInstance().getMetaData().getType() ? (String)this.metaDataContexts.get().getMetaData().getDatabases().keySet().iterator().next() : null;
    }

    @Override
    public void close() {
        for (ContextManagerLifecycleListener each : ShardingSphereServiceLoader.getServiceInstances(ContextManagerLifecycleListener.class)) {
            each.onDestroyed(this);
        }
        this.executorEngine.close();
        this.metaDataContexts.get().close();
        this.persistServiceFacade.getComputeNodePersistService().offline(this.computeNodeInstanceContext.getInstance());
        this.persistServiceFacade.getRepository().close();
    }

    @Generated
    public ComputeNodeInstanceContext getComputeNodeInstanceContext() {
        return this.computeNodeInstanceContext;
    }

    @Generated
    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    @Generated
    public StateContext getStateContext() {
        return this.stateContext;
    }

    @Generated
    public PersistServiceFacade getPersistServiceFacade() {
        return this.persistServiceFacade;
    }

    @Generated
    public MetaDataContextManager getMetaDataContextManager() {
        return this.metaDataContextManager;
    }
}

