/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

class TerminationResult
extends Result {
    private boolean allRepliesProcessed = false;
    private Set<Participant> heuristicparticipants_ = new HashSet<Participant>();
    private Set<Participant> possiblyIndoubts_ = new HashSet<Participant>();

    public TerminationResult(int numberOfRepliesToWaitFor) {
        super(numberOfRepliesToWaitFor);
    }

    public Set<Participant> getHeuristicParticipants() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        return this.heuristicparticipants_;
    }

    public Set<Participant> getPossiblyIndoubts() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        return this.possiblyIndoubts_;
    }

    @Override
    protected synchronized void calculateResultFromAllReplies() throws IllegalStateException, InterruptedException {
        if (this.allRepliesProcessed) {
            return;
        }
        boolean atLeastOneHeuristicMixedException = false;
        boolean atLeastOneHeuristicRollbackException = false;
        boolean atLeastOneHeuristicCommitException = false;
        boolean atLeastOneHeuristicHazardException = false;
        boolean noFailedReplies = true;
        boolean onePhaseCommitWithRollbackException = false;
        Stack<Reply> replies = this.getReplies();
        Enumeration enumm = replies.elements();
        while (enumm.hasMoreElements()) {
            Reply reply = (Reply)enumm.nextElement();
            if (!reply.hasFailed()) continue;
            noFailedReplies = false;
            Exception err = reply.getException();
            if (err instanceof RollbackException) {
                onePhaseCommitWithRollbackException = true;
                continue;
            }
            if (err instanceof HeurMixedException) {
                atLeastOneHeuristicMixedException = true;
                this.heuristicparticipants_.add(reply.getParticipant());
                continue;
            }
            if (err instanceof HeurCommitException) {
                atLeastOneHeuristicCommitException = true;
                atLeastOneHeuristicMixedException = atLeastOneHeuristicMixedException || atLeastOneHeuristicRollbackException || atLeastOneHeuristicHazardException;
                this.heuristicparticipants_.add(reply.getParticipant());
                continue;
            }
            if (err instanceof HeurRollbackException) {
                atLeastOneHeuristicRollbackException = true;
                atLeastOneHeuristicMixedException = atLeastOneHeuristicMixedException || atLeastOneHeuristicCommitException || atLeastOneHeuristicHazardException;
                this.heuristicparticipants_.add(reply.getParticipant());
                continue;
            }
            atLeastOneHeuristicHazardException = true;
            atLeastOneHeuristicMixedException = atLeastOneHeuristicMixedException || atLeastOneHeuristicRollbackException || atLeastOneHeuristicCommitException;
            this.heuristicparticipants_.add(reply.getParticipant());
            this.possiblyIndoubts_.add(reply.getParticipant());
        }
        if (onePhaseCommitWithRollbackException) {
            this.result_ = 6;
        } else if (atLeastOneHeuristicMixedException || atLeastOneHeuristicRollbackException && this.heuristicparticipants_.size() != replies.size() || atLeastOneHeuristicCommitException && this.heuristicparticipants_.size() != replies.size()) {
            this.result_ = 2;
        } else if (atLeastOneHeuristicHazardException) {
            this.result_ = 1;
        } else if (atLeastOneHeuristicRollbackException) {
            this.result_ = 3;
        } else if (atLeastOneHeuristicCommitException) {
            this.result_ = 4;
        } else if (noFailedReplies) {
            this.result_ = 0;
        }
        this.allRepliesProcessed = true;
    }
}

