/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.statement.AlterDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

@DistSQLExecutorCurrentRuleRequired(value=ShadowRule.class)
public final class AlterDefaultShadowAlgorithmExecutor
implements DatabaseRuleAlterExecutor<AlterDefaultShadowAlgorithmStatement, ShadowRule, ShadowRuleConfiguration> {
    private static final String DEFAULT_ALGORITHM_NAME = "default_shadow_algorithm";
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(AlterDefaultShadowAlgorithmStatement sqlStatement) {
        this.checkAlgorithms(sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment());
    }

    private void checkAlgorithms(AlgorithmSegment algorithmSegment) {
        this.checkAlgorithmCompleteness(algorithmSegment);
        this.checkAlgorithmType(algorithmSegment);
        ShadowRuleStatementChecker.checkExisted(Collections.singleton(DEFAULT_ALGORITHM_NAME), this.rule.getConfiguration().getShadowAlgorithms().keySet(), notExistedAlgorithms -> new UnregisteredAlgorithmException("Shadow", notExistedAlgorithms, new SQLExceptionIdentifier(this.database.getName())));
    }

    private void checkAlgorithmCompleteness(AlgorithmSegment algorithmSegment) {
        ShardingSpherePreconditions.checkNotEmpty((String)algorithmSegment.getName(), () -> new MissingRequiredAlgorithmException("Shadow", new SQLExceptionIdentifier("")));
    }

    private void checkAlgorithmType(AlgorithmSegment algorithmSegment) {
        TypedSPILoader.checkService(ShadowAlgorithm.class, (Object)algorithmSegment.getName(), (Properties)algorithmSegment.getProps());
    }

    public ShadowRuleConfiguration buildToBeAlteredRuleConfiguration(AlterDefaultShadowAlgorithmStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setShadowAlgorithms(this.buildAlgorithmMap(sqlStatement));
        result.setDefaultShadowAlgorithmName(DEFAULT_ALGORITHM_NAME);
        return result;
    }

    private Map<String, AlgorithmConfiguration> buildAlgorithmMap(AlterDefaultShadowAlgorithmStatement sqlStatement) {
        return Collections.singletonMap(DEFAULT_ALGORITHM_NAME, new AlgorithmConfiguration(sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment().getName(), sqlStatement.getShadowAlgorithmSegment().getAlgorithmSegment().getProps()));
    }

    public ShadowRuleConfiguration buildToBeDroppedRuleConfiguration(ShadowRuleConfiguration toBeAlteredRuleConfig) {
        return null;
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<AlterDefaultShadowAlgorithmStatement> getType() {
        return AlterDefaultShadowAlgorithmStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

