/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.distsql.statement.rdl.SetDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class SetDefaultSingleTableStorageUnitExecutor
implements DatabaseRuleAlterExecutor<SetDefaultSingleTableStorageUnitStatement, SingleRule, SingleRuleConfiguration> {
    private ShardingSphereDatabase database;
    private SingleRule rule;

    public void checkBeforeUpdate(SetDefaultSingleTableStorageUnitStatement sqlStatement) {
        this.checkDefaultStorageUnitExist(sqlStatement);
    }

    private void checkDefaultStorageUnitExist(SetDefaultSingleTableStorageUnitStatement sqlStatement) {
        if (!Strings.isNullOrEmpty((String)sqlStatement.getDefaultStorageUnit())) {
            ShardingSpherePreconditions.checkContains(this.getAllStorageUnitNames(), (Object)sqlStatement.getDefaultStorageUnit(), () -> new MissingRequiredStorageUnitsException(this.database.getName(), Collections.singleton(sqlStatement.getDefaultStorageUnit())));
        }
    }

    private Collection<String> getAllStorageUnitNames() {
        HashSet<String> result = new HashSet<String>(this.database.getResourceMetaData().getStorageUnits().keySet());
        result.addAll(this.database.getRuleMetaData().getAttributes(DataSourceMapperRuleAttribute.class).stream().flatMap(each -> each.getDataSourceMapper().keySet().stream()).collect(Collectors.toSet()));
        return result;
    }

    public SingleRuleConfiguration buildToBeAlteredRuleConfiguration(SetDefaultSingleTableStorageUnitStatement sqlStatement) {
        return new SingleRuleConfiguration(new LinkedList(), sqlStatement.getDefaultStorageUnit());
    }

    public SingleRuleConfiguration buildToBeDroppedRuleConfiguration(SingleRuleConfiguration toBeAlteredRuleConfig) {
        return toBeAlteredRuleConfig.getDefaultDataSource().isPresent() ? null : new SingleRuleConfiguration(new LinkedList(), (String)this.rule.getConfiguration().getDefaultDataSource().orElse(null));
    }

    public Class<SingleRule> getRuleClass() {
        return SingleRule.class;
    }

    public Class<SetDefaultSingleTableStorageUnitStatement> getType() {
        return SetDefaultSingleTableStorageUnitStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(SingleRule rule) {
        this.rule = rule;
    }
}

