/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.rule.changed;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class SingleTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<SingleRuleConfiguration, SingleRuleConfiguration> {
    public SingleRuleConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new SingleRuleConfiguration((Collection)YamlEngine.unmarshal((String)yamlContent, LinkedHashSet.class), null);
    }

    public SingleRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(SingleRule.class).map(SingleRule::getConfiguration).orElseGet(SingleRuleConfiguration::new);
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, SingleRuleConfiguration currentRuleConfig, SingleRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().clear();
        currentRuleConfig.getTables().addAll(toBeChangedItemConfig.getTables());
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, SingleRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().clear();
    }

    public String getType() {
        return "single.tables";
    }
}

