/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.etcd.lock;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Lock;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.shardingsphere.mode.repository.cluster.etcd.props.EtcdProperties;
import org.apache.shardingsphere.mode.repository.cluster.etcd.props.EtcdPropertyKey;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;

public final class EtcdDistributedLock
implements DistributedLock {
    private final ByteSequence lockKey;
    private final Lock lock;
    private final Lease lease;
    private final int timeToLiveSeconds;

    public EtcdDistributedLock(String lockKey, Client client, EtcdProperties props) {
        this.lockKey = ByteSequence.from((String)lockKey, (Charset)StandardCharsets.UTF_8);
        this.lock = client.getLockClient();
        this.lease = client.getLeaseClient();
        this.timeToLiveSeconds = (Integer)props.getValue(EtcdPropertyKey.TIME_TO_LIVE_SECONDS);
    }

    public boolean tryLock(long timeoutMillis) {
        try {
            this.lock.lock(this.lockKey, ((LeaseGrantResponse)this.lease.grant((long)this.timeToLiveSeconds).get()).getID()).get(timeoutMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException | TimeoutException ignored) {
            return false;
        }
    }

    public void unlock() {
        try {
            this.lock.unlock(this.lockKey).get();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

