/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;

public final class ShardingSphereMetaData {
    private final Map<String, ShardingSphereDatabase> databases;
    private final ResourceMetaData globalResourceMetaData;
    private final RuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final TemporaryConfigurationProperties temporaryProps;

    public ShardingSphereMetaData() {
        this((Map<String, ShardingSphereDatabase>)new CaseInsensitiveMap(Collections.emptyMap(), new ConcurrentHashMap()), new ResourceMetaData(Collections.emptyMap()), new RuleMetaData(Collections.emptyList()), new ConfigurationProperties(new Properties()));
    }

    public ShardingSphereMetaData(Map<String, ShardingSphereDatabase> databases, ResourceMetaData globalResourceMetaData, RuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.databases = new CaseInsensitiveMap(databases, new ConcurrentHashMap());
        this.globalResourceMetaData = globalResourceMetaData;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.temporaryProps = new TemporaryConfigurationProperties(props.getProps());
    }

    public boolean containsDatabase(String databaseName) {
        return this.databases.containsKey(databaseName);
    }

    public ShardingSphereDatabase getDatabase(String databaseName) {
        return this.databases.get(databaseName);
    }

    public void addDatabase(String databaseName, DatabaseType protocolType, ConfigurationProperties props) {
        ShardingSphereDatabase database = ShardingSphereDatabase.create(databaseName, protocolType, props);
        this.databases.put(database.getName(), database);
        this.globalRuleMetaData.getRules().forEach(each -> ((GlobalRule)each).refresh(this.databases, GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
    }

    public void dropDatabase(String databaseName) {
        this.cleanResources(this.databases.remove(databaseName));
    }

    private void cleanResources(ShardingSphereDatabase database) {
        this.globalRuleMetaData.getRules().forEach(each -> ((GlobalRule)each).refresh(this.databases, GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
        for (ShardingSphereRule each2 : database.getRuleMetaData().getRules()) {
            if (!(each2 instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)each2)).close();
        }
        database.getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class).forEach(StaticDataSourceRuleAttribute::cleanStorageNodeDataSources);
        Optional.ofNullable(database.getResourceMetaData()).ifPresent(optional -> optional.getStorageUnits().values().forEach(each -> new DataSourcePoolDestroyer(each.getDataSource()).asyncDestroy()));
    }

    @Generated
    public Map<String, ShardingSphereDatabase> getDatabases() {
        return this.databases;
    }

    @Generated
    public ResourceMetaData getGlobalResourceMetaData() {
        return this.globalResourceMetaData;
    }

    @Generated
    public RuleMetaData getGlobalRuleMetaData() {
        return this.globalRuleMetaData;
    }

    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }

    @Generated
    public TemporaryConfigurationProperties getTemporaryProps() {
        return this.temporaryProps;
    }
}

