/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.data.ShardingValueDataTypeException;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.Column;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGeneratorFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.value.AlwaysFalseShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.ColumnExtractUtils;
import org.apache.shardingsphere.sql.parser.statement.core.util.ExpressionExtractUtils;
import org.apache.shardingsphere.sql.parser.statement.core.util.SafeNumberOperationUtils;
import org.apache.shardingsphere.timeservice.core.rule.TimestampServiceRule;

public final class WhereClauseShardingConditionEngine {
    private final ShardingSphereDatabase database;
    private final ShardingRule shardingRule;
    private final TimestampServiceRule timestampServiceRule;

    public List<ShardingCondition> createShardingConditions(SQLStatementContext sqlStatementContext, List<Object> params) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Collection columnSegments = ((WhereAvailable)sqlStatementContext).getColumnSegments();
        ShardingSphereSchema schema = this.getSchema(sqlStatementContext, this.database);
        Map columnExpressionTableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().findTableNames(columnSegments, schema) : Collections.emptyMap();
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>();
        for (WhereSegment each : ((WhereAvailable)sqlStatementContext).getWhereSegments()) {
            result.addAll(this.createShardingConditions(each.getExpr(), params, columnExpressionTableNames));
        }
        return result;
    }

    private Collection<ShardingCondition> createShardingConditions(ExpressionSegment expression, List<Object> params, Map<String, String> columnExpressionTableNames) {
        Collection andPredicates = ExpressionExtractUtils.getAndPredicates((ExpressionSegment)expression);
        LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
        for (AndPredicate each : andPredicates) {
            Map<Column, Collection<ShardingConditionValue>> shardingConditionValues = this.createShardingConditionValueMap(each.getPredicates(), params, columnExpressionTableNames);
            if (shardingConditionValues.isEmpty()) {
                return Collections.emptyList();
            }
            ShardingCondition shardingCondition = this.createShardingCondition(shardingConditionValues);
            shardingCondition.setStartIndex(expression.getStartIndex());
            result.add(shardingCondition);
        }
        return result;
    }

    private ShardingSphereSchema getSchema(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        return sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName)) : database.getSchema(defaultSchemaName);
    }

    private Map<Column, Collection<ShardingConditionValue>> createShardingConditionValueMap(Collection<ExpressionSegment> predicates, List<Object> params, Map<String, String> columnTableNames) {
        HashMap<Column, Collection<ShardingConditionValue>> result = new HashMap<Column, Collection<ShardingConditionValue>>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            for (ColumnSegment columnSegment : ColumnExtractUtils.extract((ExpressionSegment)each)) {
                Column column;
                Optional<ShardingConditionValue> shardingConditionValue;
                Optional<String> tableName = Optional.ofNullable(columnTableNames.get(columnSegment.getExpression()));
                Optional shardingColumn = tableName.flatMap(optional -> this.shardingRule.findShardingColumn(columnSegment.getColumnBoundInfo().getOriginalColumn().getValue(), (String)optional));
                if (!tableName.isPresent() || !shardingColumn.isPresent() || !(shardingConditionValue = ConditionValueGeneratorFactory.generate(each, column = new Column((String)shardingColumn.get(), tableName.get()), params, this.timestampServiceRule)).isPresent()) continue;
                result.computeIfAbsent(column, unused -> new LinkedList()).add(shardingConditionValue.get());
            }
        }
        return result;
    }

    private ShardingCondition createShardingCondition(Map<Column, Collection<ShardingConditionValue>> shardingConditionValues) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<Column, Collection<ShardingConditionValue>> entry : shardingConditionValues.entrySet()) {
            try {
                ShardingConditionValue shardingConditionValue = this.mergeShardingConditionValues(entry.getKey(), entry.getValue());
                if (shardingConditionValue instanceof AlwaysFalseShardingConditionValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getValues().add(shardingConditionValue);
            }
            catch (ClassCastException ignored) {
                throw new ShardingValueDataTypeException(entry.getKey());
            }
        }
        return result;
    }

    private ShardingConditionValue mergeShardingConditionValues(Column column, Collection<ShardingConditionValue> shardingConditionValues) {
        Collection<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        HashSet<Integer> parameterMarkerIndexes = new HashSet<Integer>();
        for (ShardingConditionValue each : shardingConditionValues) {
            parameterMarkerIndexes.addAll(each.getParameterMarkerIndexes());
            if (each instanceof ListShardingConditionValue) {
                listValue = this.mergeListShardingValues(((ListShardingConditionValue)each).getValues(), listValue);
                if (!listValue.isEmpty()) continue;
                return new AlwaysFalseShardingConditionValue();
            }
            if (!(each instanceof RangeShardingConditionValue)) continue;
            try {
                rangeValue = this.mergeRangeShardingValues(((RangeShardingConditionValue)each).getValueRange(), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseShardingConditionValue();
            }
        }
        if (null == listValue) {
            return new RangeShardingConditionValue(column.getName(), column.getTableName(), rangeValue, new ArrayList<Integer>(parameterMarkerIndexes));
        }
        if (null == rangeValue) {
            return new ListShardingConditionValue(column.getName(), column.getTableName(), listValue, new ArrayList<Integer>(parameterMarkerIndexes));
        }
        return (listValue = this.mergeListAndRangeShardingValues(listValue, rangeValue)).isEmpty() ? new AlwaysFalseShardingConditionValue() : new ListShardingConditionValue(column.getName(), column.getTableName(), listValue, new ArrayList<Integer>(parameterMarkerIndexes));
    }

    private Collection<Comparable<?>> mergeListShardingValues(Collection<Comparable<?>> value1, Collection<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        value1.retainAll(value2);
        return value1;
    }

    private Range<Comparable<?>> mergeRangeShardingValues(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : SafeNumberOperationUtils.safeIntersection(value1, value2);
    }

    private Collection<Comparable<?>> mergeListAndRangeShardingValues(Collection<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!SafeNumberOperationUtils.safeContains(rangeValue, each)) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    public WhereClauseShardingConditionEngine(ShardingSphereDatabase database, ShardingRule shardingRule, TimestampServiceRule timestampServiceRule) {
        this.database = database;
        this.shardingRule = shardingRule;
        this.timestampServiceRule = timestampServiceRule;
    }
}

