/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.keygen.GeneratedKeyInsertValueParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.parameter.impl.ShardingPaginationParameterRewriter;

public final class ShardingParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final RouteContext routeContext;
    private final Map<String, ShardingSphereSchema> schemas;
    private final SQLStatementContext sqlStatementContext;

    public Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        this.addParameterRewriter(result, (ParameterRewriter)new GeneratedKeyInsertValueParameterRewriter());
        this.addParameterRewriter(result, new ShardingPaginationParameterRewriter());
        return result;
    }

    private void addParameterRewriter(Collection<ParameterRewriter> paramRewriters, ParameterRewriter toBeAddedParamRewriter) {
        if (toBeAddedParamRewriter instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)toBeAddedParamRewriter).setSchemas(this.schemas);
        }
        if (toBeAddedParamRewriter instanceof RouteContextAware) {
            ((RouteContextAware)toBeAddedParamRewriter).setRouteContext(this.routeContext);
        }
        if (toBeAddedParamRewriter.isNeedRewrite(this.sqlStatementContext)) {
            paramRewriters.add(toBeAddedParamRewriter);
        }
    }

    @Generated
    public ShardingParameterRewriterBuilder(RouteContext routeContext, Map<String, ShardingSphereSchema> schemas, SQLStatementContext sqlStatementContext) {
        this.routeContext = routeContext;
        this.schemas = schemas;
        this.sqlStatementContext = sqlStatementContext;
    }
}

