/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.pushdown.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.execute.ExecuteCallbackFactory;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.replay.StatementReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.transaction.DriverTransactionalExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;

public final class DriverJDBCPushDownExecuteExecutor {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final JDBCExecutor jdbcExecutor;

    public boolean execute(ShardingSphereDatabase database, ExecutionContext executionContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteCallback executeCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        return (Boolean)new DriverTransactionalExecutor(this.connection).execute(database, executionContext, () -> this.doExecute(database, executionContext, prepareEngine, executeCallback, addCallback, replayCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(ShardingSphereDatabase database, ExecutionContext executionContext, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, StatementExecuteCallback executeCallback, StatementAddCallback addCallback, StatementReplayCallback replayCallback) throws SQLException {
        ExecutionGroupContext executionGroupContext = prepareEngine.prepare(database.getName(), executionContext.getRouteContext(), executionContext.getExecutionUnits(), new ExecutionGroupReportContext(this.connection.getProcessId(), database.getName(), this.connection.getDatabaseConnectionManager().getConnectionContext().getGrantee()));
        for (ExecutionGroup each : executionGroupContext.getInputGroups()) {
            addCallback.add(this.getStatements((ExecutionGroup<JDBCExecutionUnit>)each), "JDBC.PREPARED_STATEMENT".equals(prepareEngine.getType()) ? this.getParameterSets((ExecutionGroup<JDBCExecutionUnit>)each) : Collections.emptyList());
        }
        replayCallback.replay();
        ProcessEngine processEngine = new ProcessEngine();
        try {
            processEngine.executeSQL(executionGroupContext, executionContext.getQueryContext());
            List results = this.jdbcExecutor.execute(executionGroupContext, new ExecuteCallbackFactory(prepareEngine.getType()).newInstance(database, executeCallback, executionContext.getSqlStatementContext().getSqlStatement()));
            if (MetaDataRefreshEngine.isRefreshMetaDataRequired((SQLStatementContext)executionContext.getSqlStatementContext())) {
                new MetaDataRefreshEngine(this.connection.getContextManager().getPersistServiceFacade().getMetaDataManagerPersistService(), database, this.metaData.getProps()).refresh(executionContext.getQueryContext().getSqlStatementContext(), executionContext.getRouteContext().getRouteUnits());
            }
            boolean bl = null != results && !results.isEmpty() && null != results.get(0) && (Boolean)results.get(0) != false;
            return bl;
        }
        finally {
            processEngine.completeSQLExecution(executionGroupContext.getReportContext().getProcessId());
        }
    }

    private Collection<Statement> getStatements(ExecutionGroup<JDBCExecutionUnit> executionGroup) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (JDBCExecutionUnit each : executionGroup.getInputs()) {
            result.add(each.getStorageResource());
        }
        return result;
    }

    private Collection<List<Object>> getParameterSets(ExecutionGroup<JDBCExecutionUnit> executionGroup) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (JDBCExecutionUnit each : executionGroup.getInputs()) {
            result.add(each.getExecutionUnit().getSqlUnit().getParameters());
        }
        return result;
    }

    public Optional<ResultSet> getResultSet(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext, Statement statement, List<? extends Statement> statements) throws SQLException {
        if (sqlStatementContext instanceof SelectStatementContext || sqlStatementContext.getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets(statements);
            if (resultSets.isEmpty()) {
                return Optional.empty();
            }
            List<QueryResult> queryResults = this.getQueryResults(resultSets);
            MergedResult mergedResult = new MergeEngine(this.metaData.getGlobalRuleMetaData(), database, this.metaData.getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext()).merge(queryResults, sqlStatementContext);
            return Optional.of(new ShardingSphereResultSet(resultSets, mergedResult, statement, sqlStatementContext));
        }
        return Optional.empty();
    }

    private List<ResultSet> getResultSets(List<? extends Statement> statements) throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(statements.size());
        for (Statement statement : statements) {
            if (null == statement.getResultSet()) continue;
            result.add(statement.getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    @Generated
    public DriverJDBCPushDownExecuteExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, JDBCExecutor jdbcExecutor) {
        this.connection = connection;
        this.metaData = metaData;
        this.jdbcExecutor = jdbcExecutor;
    }
}

