/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptColumnToken;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.column.item.CipherColumnItem;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;

public final class EncryptCreateTableTokenGenerator
implements CollectionSQLTokenGenerator<CreateTableStatementContext> {
    private final EncryptRule encryptRule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof CreateTableStatementContext && !((CreateTableStatementContext)sqlStatementContext).getSqlStatement().getColumnDefinitions().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(CreateTableStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String tableName = sqlStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        ArrayList<ColumnDefinitionSegment> columns = new ArrayList<ColumnDefinitionSegment>(sqlStatementContext.getSqlStatement().getColumnDefinitions());
        for (int index = 0; index < columns.size(); ++index) {
            ColumnDefinitionSegment each = (ColumnDefinitionSegment)columns.get(index);
            String columnName = each.getColumnName().getIdentifier().getValue();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            result.addAll(this.getColumnTokens(encryptTable.getEncryptColumn(columnName), each, columns, index));
        }
        return result;
    }

    private Collection<SQLToken> getColumnTokens(EncryptColumn encryptColumn, ColumnDefinitionSegment column, List<ColumnDefinitionSegment> columns, int index) {
        boolean lastColumn = columns.size() - 1 == index;
        int columnStopIndex = lastColumn ? column.getStopIndex() : columns.get(index + 1).getStartIndex() - 1;
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(column.getStartIndex(), columnStopIndex));
        result.add(this.getCipherColumnToken(encryptColumn, column, columnStopIndex));
        this.getAssistedQueryColumnToken(encryptColumn, column, columnStopIndex, lastColumn).ifPresent(result::add);
        this.getLikeQueryColumnToken(encryptColumn, column, columnStopIndex, lastColumn).ifPresent(result::add);
        return result;
    }

    private SQLToken getCipherColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column, int stopIndex) {
        CipherColumnItem cipherColumnItem = encryptColumn.getCipher();
        return new EncryptColumnToken(stopIndex + 1, column.getStopIndex(), cipherColumnItem.getName(), "VARCHAR(4000)");
    }

    private Optional<? extends SQLToken> getAssistedQueryColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        return encryptColumn.getAssistedQuery().map(optional -> new EncryptColumnToken(stopIndex + 1, column.getStopIndex(), encryptColumn.getAssistedQuery().get().getName(), "VARCHAR(4000)", lastColumn));
    }

    private Optional<? extends SQLToken> getLikeQueryColumnToken(EncryptColumn encryptColumn, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        return encryptColumn.getLikeQuery().map(optional -> new EncryptColumnToken(stopIndex + 1, column.getStopIndex(), encryptColumn.getLikeQuery().get().getName(), "VARCHAR(4000)", lastColumn));
    }

    @Generated
    public EncryptCreateTableTokenGenerator(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }
}

