/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.EventData;

final class EventDataToAnnotation {
    private EventDataToAnnotation() {
    }

    static String apply(EventData eventData) {
        String name = eventData.getName();
        String value = EventDataToAnnotation.toJson(eventData.getAttributes());
        return "\"" + name + "\":" + value;
    }

    private static String toJson(Attributes attributes) {
        return attributes.asMap().entrySet().stream().map(entry -> "\"" + entry.getKey() + "\":" + EventDataToAnnotation.toValue(entry.getValue())).collect(Collectors.joining(",", "{", "}"));
    }

    private static String toValue(Object o) {
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        if (o instanceof List) {
            return ((List)o).stream().map(EventDataToAnnotation::toValue).collect(Collectors.joining(",", "[", "]"));
        }
        return String.valueOf(o);
    }
}

