/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.StatusCode;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.trace.v1.internal.Status;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.StatusData;

final class SpanStatusMarshaler
extends MarshalerWithSize {
    private final ProtoEnumInfo protoStatusCode;
    private final byte[] descriptionUtf8;

    static SpanStatusMarshaler create(StatusData status) {
        ProtoEnumInfo protoStatusCode = SpanStatusMarshaler.toProtoSpanStatus(status);
        byte[] description = MarshalerUtil.toBytes(status.getDescription());
        return new SpanStatusMarshaler(protoStatusCode, description);
    }

    private SpanStatusMarshaler(ProtoEnumInfo protoStatusCode, byte[] descriptionUtf8) {
        super(SpanStatusMarshaler.computeSize(protoStatusCode, descriptionUtf8));
        this.protoStatusCode = protoStatusCode;
        this.descriptionUtf8 = descriptionUtf8;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeString(Status.MESSAGE, this.descriptionUtf8);
        output.serializeEnum(Status.CODE, this.protoStatusCode);
    }

    private static int computeSize(ProtoEnumInfo protoStatusCode, byte[] descriptionUtf8) {
        int size = 0;
        size += MarshalerUtil.sizeBytes(Status.MESSAGE, descriptionUtf8);
        return size += MarshalerUtil.sizeEnum(Status.CODE, protoStatusCode);
    }

    static ProtoEnumInfo toProtoSpanStatus(StatusData status) {
        ProtoEnumInfo protoStatusCode = Status.StatusCode.STATUS_CODE_UNSET;
        if (status.getStatusCode() == StatusCode.OK) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
        } else if (status.getStatusCode() == StatusCode.ERROR) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_ERROR;
        }
        return protoStatusCode;
    }
}

