/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ByteUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtilities {
    private EncryptionUtilities() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastMD5(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = EncryptionUtilities.calculateFileHash(in.getChannel(), EncryptionUtilities.getMD5Digest());
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA1(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = EncryptionUtilities.calculateFileHash(in.getChannel(), EncryptionUtilities.getSHA1Digest());
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA256(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = EncryptionUtilities.calculateFileHash(in.getChannel(), EncryptionUtilities.getSHA256Digest());
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fastSHA512(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = EncryptionUtilities.calculateFileHash(in.getChannel(), EncryptionUtilities.getSHA512Digest());
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String calculateFileHash(FileChannel ch, MessageDigest d) throws IOException {
        int nRead;
        ByteBuffer bb = ByteBuffer.allocateDirect(65536);
        while ((nRead = ch.read(bb)) != -1) {
            if (nRead == 0) continue;
            bb.position(0);
            bb.limit(nRead);
            d.update(bb);
            bb.clear();
        }
        return ByteUtilities.encode(d.digest());
    }

    public static String calculateMD5Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getMD5Digest(), bytes);
    }

    public static MessageDigest getDigest(String digest) {
        try {
            return MessageDigest.getInstance(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("The requested MessageDigest (%s) does not exist", digest), e);
        }
    }

    public static MessageDigest getMD5Digest() {
        return EncryptionUtilities.getDigest("MD5");
    }

    public static String calculateSHA1Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA1Digest(), bytes);
    }

    public static MessageDigest getSHA1Digest() {
        return EncryptionUtilities.getDigest("SHA-1");
    }

    public static String calculateSHA256Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA256Digest(), bytes);
    }

    public static MessageDigest getSHA256Digest() {
        return EncryptionUtilities.getDigest("SHA-256");
    }

    public static String calculateSHA512Hash(byte[] bytes) {
        return EncryptionUtilities.calculateHash(EncryptionUtilities.getSHA512Digest(), bytes);
    }

    public static MessageDigest getSHA512Digest() {
        return EncryptionUtilities.getDigest("SHA-512");
    }

    public static byte[] createCipherBytes(String key, int bitsNeeded) {
        String word = EncryptionUtilities.calculateMD5Hash(key.getBytes(StandardCharsets.UTF_8));
        return word.substring(0, bitsNeeded / 8).getBytes(StandardCharsets.UTF_8);
    }

    public static Cipher createAesEncryptionCipher(String key) throws Exception {
        return EncryptionUtilities.createAesCipher(key, 1);
    }

    public static Cipher createAesDecryptionCipher(String key) throws Exception {
        return EncryptionUtilities.createAesCipher(key, 2);
    }

    public static Cipher createAesCipher(String key, int mode) throws Exception {
        SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.createCipherBytes(key, 128), "AES");
        return EncryptionUtilities.createAesCipher(sKey, mode);
    }

    public static Cipher createAesCipher(Key key, int mode) throws Exception {
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(key.getEncoded());
        byte[] iv = d.digest();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, key, paramSpec);
        return cipher;
    }

    public static String encrypt(String key, String content) {
        try {
            return ByteUtilities.encode(EncryptionUtilities.createAesEncryptionCipher(key).doFinal(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String encryptBytes(String key, byte[] content) {
        try {
            return ByteUtilities.encode(EncryptionUtilities.createAesEncryptionCipher(key).doFinal(content));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String decrypt(String key, String hexStr) {
        try {
            return new String(EncryptionUtilities.createAesDecryptionCipher(key).doFinal(ByteUtilities.decode(hexStr)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }

    public static byte[] decryptBytes(String key, String hexStr) {
        try {
            return EncryptionUtilities.createAesDecryptionCipher(key).doFinal(ByteUtilities.decode(hexStr));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }

    public static String calculateHash(MessageDigest d, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }
}

