/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.core.advice.proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.core.advice.AbstractInstanceMethodAdvice;
import org.apache.shardingsphere.agent.plugin.core.recorder.MethodTimeRecorder;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorRegistry;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.HistogramMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricCollectorType;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;

public final class ExecuteLatencyHistogramAdvice
extends AbstractInstanceMethodAdvice {
    private final MetricConfiguration config = new MetricConfiguration("proxy_execute_latency_millis", MetricCollectorType.HISTOGRAM, "Execute latency millis histogram of ShardingSphere-Proxy", Collections.emptyList(), Collections.singletonMap("buckets", this.getBuckets()));
    private final MethodTimeRecorder methodTimeRecorder = new MethodTimeRecorder(ExecuteLatencyHistogramAdvice.class);

    private Map<String, Object> getBuckets() {
        HashMap<String, Object> result = new HashMap<String, Object>(4, 1.0f);
        result.put("type", "exp");
        result.put("start", 1);
        result.put("factor", 2);
        result.put("count", 13);
        return result;
    }

    public void beforeMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, String pluginType) {
        if (args[2] instanceof QueryCommandExecutor) {
            this.methodTimeRecorder.recordNow(method);
        }
    }

    public void afterMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, Object result, String pluginType) {
        if (args[2] instanceof QueryCommandExecutor) {
            ((HistogramMetricsCollector)MetricsCollectorRegistry.get(this.config, pluginType)).observe(this.methodTimeRecorder.getElapsedTimeAndClean(method));
        }
    }
}

