<!--
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 -->

# Community

Every volunteer project obtains its strength from the people involved in it. We invite you to participate as much or as little as you choose.

You can participate in the community as follows:

* Use our project and provide a feedback.
* Provide us with the use-cases.
* Report bugs and submit patches.
* Contribute code and documentation.

## Community events

Everyone is welcome to join our community events. We have a community office hour every 4 weeks. Please register to the event you want to attend: https://bit.ly/3UBmxFY

## Sedona on LinkedIn

[Apache Sedona@LinkedIn](https://www.linkedin.com/company/apache-sedona)

## Sedona on X

[Apache Sedona@X](https://X.com/ApacheSedona)

## Discord Server

[![Apache Sedona Community Discord Server](https://dcbadge.limes.pink/api/server/https://discord.gg/9A3k5dEBsY)](https://discord.gg/9A3k5dEBsY)

## Get help

You can ask for help or contribute to the project. Before submitting an issue, please:

* Verify that the bug does in fact exist.
* Search the issue tracker to verify there is no existing issue reporting the bug you’ve found.
* Consider tracking down the bug yourself in the Sedona’s source and submitting a patch along with your bug report. This is a great time saver for the Sedona developers and helps ensure the bug will be fixed quickly.

Enhancement requests for new features are also welcome. The more concrete and rationale the request is, the greater the chance it will be incorporated into future releases.

* [Sedona JIRA](https://issues.apache.org/jira/projects/SEDONA): bug reports and feature requests
* [Sedona GitHub Issues](https://github.com/apache/sedona/issues?q=sort%3Aupdated-desc+is%3Aissue+is%3Aopen): bug reports and feature requests
* [Sedona GitHub Discussion](https://github.com/apache/sedona/discussions): project development and general questions
* [Sedona Mailing Lists](https://lists.apache.org/list.html?sedona.apache.org): [dev@sedona.apache.org](https://lists.apache.org/list.html?dev@sedona.apache.org): project development and general questions.

For the mailing list, Please first subscribe and then post emails. To subscribe, please send an email (leave the subject and content blank) to [dev-subscribe@sedona.apache.org](mailto:dev-subscribe@sedona.apache.org?subject=Subscribe&body=Subscribe)

!!!tip
    All serious conversation such as voting will only take place on the mailing list. This includes voting on each release candidate or major change to the project. Please pay attention to the mailing list!
