/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser.node;

import java.util.Objects;
import org.apache.sedona.shaded.jiffle.parser.node.ListLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.SourceWriter;
import org.apache.sedona.shaded.jiffle.parser.node.Statement;
import org.apache.sedona.shaded.jiffle.parser.node.Variable;

public class LoopInLiteralList
implements Statement {
    private Statement statement;
    private Variable loopVariable;
    private ListLiteral listLiteral;

    public LoopInLiteralList(Variable loopVariable, ListLiteral listLiteral, Statement statement) {
        this.loopVariable = loopVariable;
        this.listLiteral = listLiteral;
        this.statement = statement;
    }

    @Override
    public void write(SourceWriter w) {
        w.indent().append("for(Double ").append(this.loopVariable).append(" : ").append(this.listLiteral);
        w.append(") {").newLine();
        w.inc();
        this.statement.write(w);
        w.dec();
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoopInLiteralList that = (LoopInLiteralList)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.loopVariable, that.loopVariable) && Objects.equals(this.listLiteral, that.listLiteral);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.loopVariable, this.listLiteral);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Variable getLoopVariable() {
        return this.loopVariable;
    }

    public ListLiteral getListLiteral() {
        return this.listLiteral;
    }
}

