/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.geometry.PrimitiveArrays;
import com.google.common.geometry.S2Coder;
import com.google.common.geometry.S2Shape;
import com.google.common.geometry.S2TaggedShapeCoder;
import com.google.common.geometry.UintVectorCoder;
import com.google.common.primitives.ImmutableLongArray;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.List;

@GwtCompatible
public class VectorCoder<T>
implements S2Coder<List<T>> {
    static final VectorCoder<byte[]> BYTE_ARRAY = new VectorCoder<byte[]>(new S2Coder<byte[]>(){

        @Override
        public void encode(byte[] value, OutputStream output) throws IOException {
            output.write(value);
        }

        @Override
        public byte[] decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
            byte[] b = new byte[Ints.checkedCast(cursor.remaining())];
            for (int i = 0; i < b.length; ++i) {
                b[i] = data.get(cursor.position++);
            }
            return b;
        }
    });
    static final VectorCoder<String> STRING = new VectorCoder<String>(new S2Coder<String>(){

        @Override
        public void encode(String value, OutputStream output) throws IOException {
            output.write(value.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public String decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
            byte[] b = new byte[Ints.checkedCast(cursor.remaining())];
            for (int i = 0; i < b.length; ++i) {
                b[i] = data.get(cursor.position++);
            }
            return new String(b, StandardCharsets.UTF_8);
        }
    });
    @GwtIncompatible(value="S2TaggedShapeCoder")
    public static final VectorCoder<S2Shape> FAST_SHAPE = new VectorCoder<S2Shape>(S2TaggedShapeCoder.FAST);
    @GwtIncompatible(value="S2TaggedShapeCoder")
    public static final VectorCoder<S2Shape> COMPACT_SHAPE = new VectorCoder<S2Shape>(S2TaggedShapeCoder.COMPACT);
    private final S2Coder<T> coder;

    public VectorCoder(S2Coder<T> coder) {
        this.coder = coder;
    }

    @Override
    public void encode(List<T> values, OutputStream output) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImmutableLongArray.Builder offsetsBuilder = ImmutableLongArray.builder(values.size());
        for (T value : values) {
            this.coder.encode(value, bos);
            offsetsBuilder.add(bos.size());
        }
        UintVectorCoder.UINT64.encode(PrimitiveArrays.Longs.fromImmutableLongArray(offsetsBuilder.build()), output);
        bos.writeTo(output);
    }

    @Override
    public List<T> decode(final PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        final PrimitiveArrays.Longs offsets = UintVectorCoder.UINT64.decode(data, cursor);
        final long offset = cursor.position;
        cursor.position = cursor.position + (offsets.length() > 0 ? offsets.get(offsets.length() - 1) : 0L);
        return new AbstractList<T>(){

            @Override
            public T get(int position) {
                long start = position == 0 ? 0L : offsets.get(position - 1);
                long end = offsets.get(position);
                return VectorCoder.this.coder.decode(data, data.cursor(offset + start, offset + end));
            }

            @Override
            public int size() {
                return Ints.checkedCast(offsets.length());
            }
        };
    }
}

