/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPSession;

public abstract class HTTPUtil {
    private static final Logger logger = LoggerFactory.getLogger(HTTPUtil.class);
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    public static final Charset ASCII = StandardCharsets.US_ASCII;
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String DRIVELETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static byte[] readbinaryfile(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] byArray = HTTPUtil.readbinaryfile(fis);
            return byArray;
        }
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    public static File fillTempFile(String base, String content) throws IOException {
        File tmpdir;
        String tmppath = System.getenv("TEMP");
        if (tmppath == null || tmppath.length() == 0) {
            tmppath = "/tmp";
        }
        if (!(tmpdir = new File(tmppath)).exists() || !tmpdir.canWrite()) {
            throw new IOException("Cannot create temp file: no tmp dir");
        }
        try {
            int index = base.lastIndexOf(46);
            if (index < 0) {
                index = base.length();
            }
            String suffix = base.substring(index, base.length());
            String prefix = base.substring(0, index);
            if (prefix.length() == 0) {
                throw new IOException("Malformed base: " + base);
            }
            File f = File.createTempFile(prefix, suffix, tmpdir);
            try (FileOutputStream fw = new FileOutputStream(f);){
                fw.write(content.getBytes(UTF8));
            }
            return f;
        }
        catch (IOException e) {
            throw new IOException("Cannot create temp file", e);
        }
    }

    static boolean equals(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    static boolean schemeEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1.length() == 0 ^ s2.length() == 0) {
            return true;
        }
        return s1.equals(s2);
    }

    public static URI parseToURI(String u) throws URISyntaxException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < u.length(); ++i) {
            char c = u.charAt(i);
            if (c == '\\') {
                if (i + 1 == u.length()) {
                    throw new URISyntaxException(u, "Trailing '' at end of url");
                }
                buf.append("%5c");
                c = u.charAt(++i);
                buf.append(String.format("%%%02x", c));
                continue;
            }
            buf.append(c);
        }
        return new URI(buf.toString());
    }

    static URI uriExclude(URI uri, URIPart ... excludes) {
        URIBuilder urib = new URIBuilder();
        EnumSet<URIPart[]> set = EnumSet.of(excludes[0], excludes);
        block11: for (URIPart part : URIPart.values()) {
            if (set.contains((Object)part)) continue;
            switch (part) {
                case SCHEME: {
                    urib.setScheme(uri.getScheme());
                    continue block11;
                }
                case USERINFO: {
                    urib.setUserInfo(uri.getRawUserInfo());
                    continue block11;
                }
                case HOST: {
                    urib.setHost(uri.getHost());
                    continue block11;
                }
                case PORT: {
                    urib.setPort(uri.getPort());
                    continue block11;
                }
                case PATH: {
                    urib.setPath(uri.getPath());
                    continue block11;
                }
                case QUERY: {
                    urib.setCustomQuery(uri.getQuery());
                    continue block11;
                }
                case FRAGMENT: {
                    urib.setFragment(uri.getFragment());
                }
            }
        }
        try {
            return urib.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected static Map<HTTPSession.Prop, Object> merge(Map<HTTPSession.Prop, Object> globalsettings, Map<HTTPSession.Prop, Object> localsettings) {
        ConcurrentHashMap<HTTPSession.Prop, Object> merge = new ConcurrentHashMap<HTTPSession.Prop, Object>();
        for (HTTPSession.Prop key : globalsettings.keySet()) {
            merge.put(key, globalsettings.get((Object)key));
        }
        for (HTTPSession.Prop key : localsettings.keySet()) {
            merge.put(key, localsettings.get((Object)key));
        }
        return merge;
    }

    public static String nullify(String s2) {
        if (s2 != null && s2.length() == 0) {
            s2 = null;
        }
        return s2;
    }

    String joinList(List<String> list, String delim) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(list.get(i));
        }
        return buf.toString();
    }

    public static String canonjoin(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = HTTPUtil.canonicalpath(prefix);
        suffix = HTTPUtil.canonicalpath(suffix);
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        int prelen = prefix.length();
        if (prelen > 0 && result.charAt(prelen - 1) != '/') {
            result.append('/');
            ++prelen;
        }
        if (suffix.length() > 0 && suffix.charAt(0) == '/') {
            result.append(suffix.substring(1));
        } else {
            result.append(suffix);
        }
        int len = result.length();
        if (len > 0 && result.charAt(len - 1) == '/') {
            result.deleteCharAt(len - 1);
            --len;
        }
        return result.toString();
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(path);
        HTTPUtil.canonicalpath(b);
        return b.toString();
    }

    public static void canonicalpath(StringBuilder s2) {
        boolean isabs;
        if (s2 == null || s2.length() == 0) {
            return;
        }
        int index = 0;
        while ((index = s2.indexOf("\\", index)) >= 0) {
            s2.replace(index, index + 1, "/");
        }
        boolean bl = isabs = s2.charAt(0) == '/';
        while (s2.length() != 0 && s2.charAt(0) == '/') {
            s2.deleteCharAt(0);
        }
        boolean hasdrive = HTTPUtil.hasDriveLetter(s2);
        if (hasdrive) {
            s2.setCharAt(0, Character.toLowerCase(s2.charAt(0)));
        }
        while (s2.length() > 0 && s2.charAt(s2.length() - 1) == '/') {
            s2.deleteCharAt(s2.length() - 1);
        }
        if (!hasdrive && isabs) {
            s2.insert(0, '/');
        }
    }

    public static String relpath(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(path);
        HTTPUtil.canonicalpath(b);
        if (b.length() > 0) {
            if (b.charAt(0) == '/') {
                b.deleteCharAt(0);
            }
            if (HTTPUtil.hasDriveLetter(b)) {
                b.delete(0, 2);
            }
        }
        return b.toString();
    }

    public static boolean hasDriveLetter(String path) {
        return path != null && path.length() >= 2 && path.charAt(1) == ':' && DRIVELETTERS.indexOf(path.charAt(0)) >= 0;
    }

    protected static boolean hasDriveLetter(StringBuilder path) {
        return path.length() >= 2 && path.charAt(1) == ':' && DRIVELETTERS.indexOf(path.charAt(0)) >= 0;
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && path.length() > 0 && (path.charAt(0) == '/' || HTTPUtil.hasDriveLetter(path));
    }

    public static String abspath(String path) {
        if (path == null) {
            return "/";
        }
        StringBuilder b = new StringBuilder(path);
        HTTPUtil.canonicalpath(b);
        if (b.charAt(0) == '/') {
            b.deleteCharAt(0);
        }
        if (b.charAt(0) != '/' || !HTTPUtil.hasDriveLetter(b)) {
            b.insert(0, '/');
        }
        return b.toString();
    }

    public static String readtextfile(InputStream stream) throws IOException {
        InputStreamReader rdr = new InputStreamReader(stream, UTF8);
        return HTTPUtil.readtextfile(rdr);
    }

    public static String readtextfile(Reader rdr) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = rdr.read()) >= 0) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static void writebinaryfile(byte[] content, File dst) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(dst);){
            fos.write(content);
        }
    }

    static class ContentEncodingInterceptor
    extends InterceptCommon
    implements HttpResponseInterceptor {
        ContentEncodingInterceptor() {
        }

        @Override
        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity;
            if (response == null) {
                return;
            }
            Header[] hdrs = response.getAllHeaders();
            if (hdrs == null) {
                return;
            }
            boolean modified = false;
            for (int i = 0; i < hdrs.length; ++i) {
                String value;
                Header h2 = hdrs[i];
                if (!h2.getName().equalsIgnoreCase("content-encoding") || !(value = h2.getValue()).trim().toLowerCase().endsWith("-endian")) continue;
                hdrs[i] = new BasicHeader("X-Content-Encoding", value);
                modified = true;
            }
            if (modified) {
                response.setHeaders(hdrs);
            }
            if ((entity = response.getEntity()) != null && (ceheader = entity.getContentEncoding()) != null) {
                String string = ceheader.getValue();
            }
        }
    }

    public static class InterceptRequest
    extends InterceptCommon
    implements HttpRequestInterceptor {
        @Override
        public synchronized void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            this.request = request;
            this.context = context;
            if (this.printheaders) {
                this.printHeaders();
            } else if (this.request != null) {
                Header[] hdrs = this.request.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    public static class InterceptResponse
    extends InterceptCommon
    implements HttpResponseInterceptor {
        @Override
        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            this.response = response;
            this.context = context;
            if (this.printheaders) {
                this.printHeaders();
            } else if (this.response != null) {
                Header[] hdrs = this.response.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    static abstract class InterceptCommon {
        private static final Logger logger = LoggerFactory.getLogger(InterceptCommon.class);
        protected HttpContext context = null;
        protected List<Header> headers = new ArrayList<Header>();
        protected HttpRequest request = null;
        protected HttpResponse response = null;
        protected boolean printheaders = false;

        InterceptCommon() {
        }

        public InterceptCommon setPrint(boolean tf) {
            this.printheaders = tf;
            return this;
        }

        public void clear() {
            this.context = null;
            this.headers.clear();
            this.request = null;
            this.response = null;
        }

        public synchronized HttpRequest getRequest() {
            return this.request;
        }

        public synchronized HttpResponse getResponse() {
            return this.response;
        }

        public synchronized HttpContext getContext() {
            return this.context;
        }

        public synchronized HttpEntity getRequestEntity() {
            if (this.request != null && this.request instanceof HttpEntityEnclosingRequest) {
                return ((HttpEntityEnclosingRequest)this.request).getEntity();
            }
            return null;
        }

        synchronized HttpEntity getResponseEntity() {
            if (this.response != null) {
                return this.response.getEntity();
            }
            return null;
        }

        public synchronized List<Header> getHeaders(String key) {
            ArrayList<Header> keyh = new ArrayList<Header>();
            for (Header h2 : this.headers) {
                if (!h2.getName().equalsIgnoreCase(key.trim())) continue;
                keyh.add(h2);
            }
            return keyh;
        }

        synchronized List<Header> getHeaders() {
            return this.headers;
        }

        void printHeaders() {
            Header[] hdrs;
            if (this.request != null) {
                hdrs = this.request.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                logger.debug("Request Headers:");
                for (Header h2 : hdrs) {
                    logger.debug(h2.toString());
                }
            }
            if (this.response != null) {
                hdrs = this.response.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                logger.debug("Response Headers:");
                for (Header h2 : hdrs) {
                    logger.debug(h2.toString());
                }
            }
        }
    }

    static enum URIPart {
        SCHEME,
        USERINFO,
        HOST,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

