/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.raster.serde.KryoUtil;

public class SampleModelSerializer
extends Serializer<SampleModel> {
    private static final int TYPE_BANDED = 1;
    private static final int TYPE_PIXEL_INTERLEAVED = 2;
    private static final int TYPE_SINGLE_PIXEL_PACKED = 3;
    private static final int TYPE_MULTI_PIXEL_PACKED = 4;
    private static final int TYPE_COMPONENT_JAI = 5;
    private static final int TYPE_COMPONENT = 6;

    private static int sampleModelTypeOf(SampleModel sampleModel) {
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel instanceof PixelInterleavedSampleModel) {
                return 2;
            }
            if (sampleModel instanceof BandedSampleModel) {
                return 1;
            }
            if (sampleModel instanceof ComponentSampleModelJAI) {
                return 5;
            }
            return 6;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return 3;
        }
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            return 4;
        }
        throw new UnsupportedOperationException("Unsupported SampleModel type: " + sampleModel.getClass().getName());
    }

    public void write(Kryo kryo, Output output, SampleModel sampleModel) {
        int sampleModelType = SampleModelSerializer.sampleModelTypeOf(sampleModel);
        output.writeInt(sampleModelType);
        output.writeInt(sampleModel.getTransferType());
        output.writeInt(sampleModel.getWidth());
        output.writeInt(sampleModel.getHeight());
        switch (sampleModelType) {
            case 1: {
                BandedSampleModel sm = (BandedSampleModel)sampleModel;
                KryoUtil.writeIntArray(output, sm.getBankIndices());
                KryoUtil.writeIntArray(output, sm.getBandOffsets());
                break;
            }
            case 2: {
                PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)sampleModel;
                output.writeInt(sm.getPixelStride());
                output.writeInt(sm.getScanlineStride());
                KryoUtil.writeIntArray(output, sm.getBandOffsets());
                break;
            }
            case 5: 
            case 6: {
                ComponentSampleModel sm = (ComponentSampleModel)sampleModel;
                output.writeInt(sm.getPixelStride());
                output.writeInt(sm.getScanlineStride());
                KryoUtil.writeIntArray(output, sm.getBankIndices());
                KryoUtil.writeIntArray(output, sm.getBandOffsets());
                break;
            }
            case 3: {
                SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)sampleModel;
                output.writeInt(sm.getScanlineStride());
                KryoUtil.writeIntArray(output, sm.getBitMasks());
                break;
            }
            case 4: {
                MultiPixelPackedSampleModel sm = (MultiPixelPackedSampleModel)sampleModel;
                output.writeInt(sm.getPixelBitStride());
                output.writeInt(sm.getScanlineStride());
                output.writeInt(sm.getDataBitOffset());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown SampleModel type: " + sampleModel.getClass().getName());
            }
        }
    }

    public SampleModel read(Kryo kryo, Input input, Class<SampleModel> type) {
        int sampleModelType = input.readInt();
        int transferType = input.readInt();
        int width = input.readInt();
        int height = input.readInt();
        switch (sampleModelType) {
            case 1: {
                int[] bankIndices = KryoUtil.readIntArray(input);
                int[] bandOffsets = KryoUtil.readIntArray(input);
                return RasterFactory.createBandedSampleModel((int)transferType, (int)width, (int)height, (int)bankIndices.length, (int[])bankIndices, (int[])bandOffsets);
            }
            case 2: {
                int pixelStride = input.readInt();
                int scanLineStride = input.readInt();
                int[] bandOffsets = KryoUtil.readIntArray(input);
                return RasterFactory.createPixelInterleavedSampleModel((int)transferType, (int)width, (int)height, (int)pixelStride, (int)scanLineStride, (int[])bandOffsets);
            }
            case 5: 
            case 6: {
                int pixelStride = input.readInt();
                int scanLineStride = input.readInt();
                int[] bankIndices = KryoUtil.readIntArray(input);
                int[] bandOffsets = KryoUtil.readIntArray(input);
                if (sampleModelType == 5) {
                    return new ComponentSampleModelJAI(transferType, width, height, pixelStride, scanLineStride, bankIndices, bandOffsets);
                }
                return new ComponentSampleModel(transferType, width, height, pixelStride, scanLineStride, bankIndices, bandOffsets);
            }
            case 3: {
                int scanLineStride = input.readInt();
                int[] bitMasks = KryoUtil.readIntArray(input);
                return new SinglePixelPackedSampleModel(transferType, width, height, scanLineStride, bitMasks);
            }
            case 4: {
                int pixelStride = input.readInt();
                int scanLineStride = input.readInt();
                int dataBitOffset = input.readInt();
                return new MultiPixelPackedSampleModel(transferType, width, height, pixelStride, scanLineStride, dataBitOffset);
            }
        }
        throw new UnsupportedOperationException("Unsupported SampleModel type: " + sampleModelType);
    }
}

