/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sedona.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.wololo.geojson.Feature;
import org.wololo.jts2geojson.GeoJSONWriter;

/** @author Arizona State University DataSystems Lab */

// TODO: Auto-generated Javadoc

/** The Class testGeoJSON. */
public class testGeoJSON {

  /** The sc. */
  public static JavaSparkContext sc;

  /** Once executed before all. */
  @BeforeClass
  public static void onceExecutedBeforeAll() {
    SparkConf conf =
        new SparkConf().setAppName("JobTileMatchWithAcronymExpension").setMaster("local[2]");
    sc = new JavaSparkContext(conf);
    Logger.getLogger("org").setLevel(Level.WARN);
    Logger.getLogger("akka").setLevel(Level.WARN);
  }

  /** Tear down. */
  @AfterClass
  public static void TearDown() {
    sc.stop();
  }

  /** Jts 2 geonjson. */
  @Test
  public void jts2geonjson() {
    GeometryFactory geometryFactory = new GeometryFactory();
    Coordinate coordinate = new Coordinate(1.0, 2.0);
    Geometry point = geometryFactory.createPoint(coordinate);

    GeoJSONWriter writer = new GeoJSONWriter();
    Map<String, Object> userData = new HashMap<String, Object>();
    userData.put("UserData", "Payload");
    Feature jsonFeature = new Feature(writer.write(point), userData);

    String jsonstring = jsonFeature.toString();
    assert jsonstring.equals(
        "{\"type\":\"Feature\",\"geometry\":{\"type\":\"Point\",\"coordinates\":[1.0,2.0]},\"properties\":{\"UserData\":\"Payload\"}}");
  }
}
