% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_rdd.R
\name{minimum_bounding_box}
\alias{minimum_bounding_box}
\title{Find the minimal bounding box of a geometry.}
\usage{
minimum_bounding_box(x)
}
\arguments{
\item{x}{A Sedona spatial RDD.}
}
\value{
A minimum bounding box object.
}
\description{
Given a Sedona spatial RDD, find the axis-aligned minimal bounding box of the
geometry represented by the RDD.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_shapefile_to_typed_rdd(
    sc,
    location = input_location, type = "polygon"
  )
  boundary <- minimum_bounding_box(rdd)
}

}
\seealso{
Other Spatial RDD aggregation routine: 
\code{\link{approx_count}()}
}
\concept{Spatial RDD aggregation routine}
