/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.simplify;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.sedona.common.simplify.BaseSimplifier;
import org.apache.sedona.common.simplify.CoordinatesSimplifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class LineStringSimplifier
extends BaseSimplifier {
    public static Geometry simplify(Geometry geom, boolean preserveCollapsed, double epsilon) {
        Coordinate[] simplified = CoordinatesSimplifier.simplifyInPlace(geom.getCoordinates(), epsilon, 2);
        GeometryFactory geometryFactory = geom.getFactory();
        if (simplified.length == 1) {
            if (preserveCollapsed) {
                return geometryFactory.createLineString(ArrayUtils.addAll(simplified, simplified));
            }
            return geometryFactory.createLineString(simplified);
        }
        if (simplified.length == 2 && !preserveCollapsed) {
            if (simplified[0] == simplified[1]) {
                return geometryFactory.createLineString(simplified);
            }
            return geometryFactory.createLineString(simplified);
        }
        return geometryFactory.createLineString(simplified);
    }
}

