/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.geometry.Platform;
import com.google.common.geometry.S2Point;
import java.math.BigDecimal;

@GwtCompatible
strictfp final class BigPoint
implements Comparable<BigPoint> {
    final BigDecimal x;
    final BigDecimal y;
    final BigDecimal z;

    BigPoint(S2Point p) {
        this(Platform.newBigDecimal(p.x), Platform.newBigDecimal(p.y), Platform.newBigDecimal(p.z));
    }

    BigPoint(BigDecimal x, BigDecimal y, BigDecimal z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    S2Point toS2Point() {
        return new S2Point(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue());
    }

    BigPoint crossProd(BigPoint that) {
        return new BigPoint(this.y.multiply(that.z).subtract(this.z.multiply(that.y)), this.z.multiply(that.x).subtract(this.x.multiply(that.z)), this.x.multiply(that.y).subtract(this.y.multiply(that.x)));
    }

    BigDecimal dotProd(BigPoint that) {
        return this.x.multiply(that.x).add(this.y.multiply(that.y)).add(this.z.multiply(that.z));
    }

    BigDecimal dotProd(S2Point that) {
        return this.dotProd(new BigPoint(that));
    }

    boolean isLinearlyDependent(BigPoint p) {
        BigPoint n = this.crossProd(p);
        return n.x.signum() == 0 && n.y.signum() == 0 && n.z.signum() == 0;
    }

    boolean isAntipodal(BigPoint p) {
        return this.isLinearlyDependent(p) && this.dotProd(p).signum() < 0;
    }

    BigDecimal norm2() {
        return this.dotProd(this);
    }

    @Override
    public int compareTo(BigPoint p) {
        int result = this.x.compareTo(p.x);
        if (result != 0) {
            return result;
        }
        result = this.y.compareTo(p.y);
        if (result != 0) {
            return result;
        }
        return this.z.compareTo(p.z);
    }

    public boolean equals(Object that) {
        if (!(that instanceof BigPoint)) {
            return false;
        }
        BigPoint thatPoint = (BigPoint)that;
        return this.x.equals(thatPoint.x) && this.y.equals(thatPoint.y) && this.z.equals(thatPoint.z);
    }

    public int hashCode() {
        return Objects.hashCode(this.x, this.y, this.z);
    }
}

