/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.impl.CircleImpl;
import org.locationtech.spatial4j.shape.impl.GeoCircle;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class ShapeFactoryImpl
implements ShapeFactory {
    protected final SpatialContext ctx;
    private final boolean normWrapLongitude;

    public ShapeFactoryImpl(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
        this.normWrapLongitude = ctx.isGeo() && factory.normWrapLongitude;
    }

    @Override
    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    @Override
    public boolean isNormWrapLongitude() {
        return this.normWrapLongitude;
    }

    @Override
    public double normX(double x) {
        if (this.normWrapLongitude) {
            x = DistanceUtils.normLonDEG(x);
        }
        return x;
    }

    @Override
    public double normY(double y) {
        return y;
    }

    @Override
    public double normZ(double z) {
        return z;
    }

    @Override
    public double normDist(double d) {
        return d;
    }

    @Override
    public void verifyX(double x) {
        Rectangle bounds = this.ctx.getWorldBounds();
        if (x < bounds.getMinX() || x > bounds.getMaxX()) {
            throw new InvalidShapeException("Bad X value " + x + " is not in boundary " + bounds);
        }
    }

    @Override
    public void verifyY(double y) {
        Rectangle bounds = this.ctx.getWorldBounds();
        if (y < bounds.getMinY() || y > bounds.getMaxY()) {
            throw new InvalidShapeException("Bad Y value " + y + " is not in boundary " + bounds);
        }
    }

    @Override
    public void verifyZ(double z) {
    }

    @Override
    public Point pointXY(double x, double y) {
        this.verifyX(x);
        this.verifyY(y);
        return new PointImpl(x, y, this.ctx);
    }

    @Override
    public Point pointXYZ(double x, double y, double z) {
        return this.pointXY(x, y);
    }

    @Override
    public Rectangle rect(Point lowerLeft, Point upperRight) {
        return this.rect(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY());
    }

    @Override
    public Rectangle rect(double minX, double maxX, double minY, double maxY) {
        Rectangle bounds = this.ctx.getWorldBounds();
        if (minY < bounds.getMinY() || maxY > bounds.getMaxY()) {
            throw new InvalidShapeException("Y values [" + minY + " to " + maxY + "] not in boundary " + bounds);
        }
        if (minY > maxY) {
            throw new InvalidShapeException("maxY must be >= minY: " + minY + " to " + maxY);
        }
        if (this.ctx.isGeo()) {
            this.verifyX(minX);
            this.verifyX(maxX);
            if (minX == 180.0 && minX != maxX) {
                minX = -180.0;
            } else if (maxX == -180.0 && minX != maxX) {
                maxX = 180.0;
            }
        } else {
            if (minX < bounds.getMinX() || maxX > bounds.getMaxX()) {
                throw new InvalidShapeException("X values [" + minX + " to " + maxX + "] not in boundary " + bounds);
            }
            if (minX > maxX) {
                throw new InvalidShapeException("maxX must be >= minX: " + minX + " to " + maxX);
            }
        }
        return new RectangleImpl(minX, maxX, minY, maxY, this.ctx);
    }

    @Override
    public Circle circle(double x, double y, double distance) {
        return this.circle(this.pointXY(x, y), distance);
    }

    @Override
    public Circle circle(Point point, double distance) {
        if (distance < 0.0) {
            throw new InvalidShapeException("distance must be >= 0; got " + distance);
        }
        if (this.ctx.isGeo()) {
            if (distance > 180.0) {
                distance = 180.0;
            }
            return new GeoCircle(point, distance, this.ctx);
        }
        return new CircleImpl(point, distance, this.ctx);
    }

    @Override
    public Shape lineString(List<Point> points, double buf) {
        return new BufferedLineString(points, buf, this.ctx.isGeo(), this.ctx);
    }

    @Override
    public ShapeFactory.LineStringBuilder lineString() {
        return new ShapeFactory.LineStringBuilder(){
            final List<Point> points = new ArrayList<Point>();
            double bufferDistance = 0.0;

            @Override
            public ShapeFactory.LineStringBuilder buffer(double distance) {
                this.bufferDistance = distance;
                return this;
            }

            @Override
            public ShapeFactory.LineStringBuilder pointXY(double x, double y) {
                this.points.add(ShapeFactoryImpl.this.pointXY(x, y));
                return this;
            }

            @Override
            public ShapeFactory.LineStringBuilder pointXYZ(double x, double y, double z) {
                this.points.add(ShapeFactoryImpl.this.pointXYZ(x, y, z));
                return this;
            }

            @Override
            public ShapeFactory.LineStringBuilder pointLatLon(double latitude, double longitude) {
                this.points.add(ShapeFactoryImpl.this.pointLatLon(latitude, longitude));
                return this;
            }

            @Override
            public Shape build() {
                return new BufferedLineString(this.points, this.bufferDistance, false, ShapeFactoryImpl.this.ctx);
            }
        };
    }

    @Override
    public <S extends Shape> ShapeCollection<S> multiShape(List<S> coll) {
        return new ShapeCollection<S>(coll, this.ctx);
    }

    @Override
    public <T extends Shape> ShapeFactory.MultiShapeBuilder<T> multiShape(Class<T> shapeClass) {
        return new GeneralShapeMultiShapeBuilder();
    }

    @Override
    public ShapeFactory.MultiPointBuilder multiPoint() {
        return new GeneralShapeMultiShapeBuilder();
    }

    @Override
    public ShapeFactory.MultiLineStringBuilder multiLineString() {
        return new GeneralShapeMultiShapeBuilder();
    }

    @Override
    public ShapeFactory.MultiPolygonBuilder multiPolygon() {
        return new GeneralShapeMultiShapeBuilder();
    }

    @Override
    public ShapeFactory.PolygonBuilder polygon() {
        throw new UnsupportedOperationException("Unsupported shape of this SpatialContext. Try JTS or Geo3D.");
    }

    protected class GeneralShapeMultiShapeBuilder<T extends Shape>
    implements ShapeFactory.MultiShapeBuilder<T>,
    ShapeFactory.MultiPointBuilder,
    ShapeFactory.MultiLineStringBuilder,
    ShapeFactory.MultiPolygonBuilder {
        protected List<Shape> shapes = new ArrayList<Shape>();

        protected GeneralShapeMultiShapeBuilder() {
        }

        @Override
        public ShapeFactory.MultiShapeBuilder<T> add(T shape) {
            this.shapes.add((Shape)shape);
            return this;
        }

        @Override
        public ShapeFactory.MultiPointBuilder pointXY(double x, double y) {
            this.shapes.add(ShapeFactoryImpl.this.pointXY(x, y));
            return this;
        }

        @Override
        public ShapeFactory.MultiPointBuilder pointXYZ(double x, double y, double z) {
            this.shapes.add(ShapeFactoryImpl.this.pointXYZ(x, y, z));
            return this;
        }

        @Override
        public ShapeFactory.MultiPointBuilder pointLatLon(double latitude, double longitude) {
            this.shapes.add(ShapeFactoryImpl.this.pointLatLon(latitude, longitude));
            return this;
        }

        @Override
        public ShapeFactory.LineStringBuilder lineString() {
            return ShapeFactoryImpl.this.lineString();
        }

        @Override
        public ShapeFactory.MultiLineStringBuilder add(ShapeFactory.LineStringBuilder lineStringBuilder) {
            this.shapes.add(lineStringBuilder.build());
            return this;
        }

        @Override
        public ShapeFactory.PolygonBuilder polygon() {
            return ShapeFactoryImpl.this.polygon();
        }

        @Override
        public ShapeFactory.MultiPolygonBuilder add(ShapeFactory.PolygonBuilder polygonBuilder) {
            this.shapes.add(polygonBuilder.build());
            return this;
        }

        @Override
        public Shape build() {
            return new ShapeCollection<Shape>(this.shapes, ShapeFactoryImpl.this.ctx);
        }
    }
}

