/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import javax.annotation.concurrent.Immutable;
import ucar.nc2.util.HashMapLRU;

@Immutable
public class GaussianLatitudes {
    private static final double XLIM = 1.0E-7;
    private static final HashMapLRU<Integer, GaussianLatitudes> hash = new HashMapLRU(10, 20);
    public final double[] gaussw;
    public final double[] latd;

    public static GaussianLatitudes factory(int nlats) {
        GaussianLatitudes glats = (GaussianLatitudes)hash.get(nlats);
        if (glats == null) {
            glats = new GaussianLatitudes(nlats);
            hash.put(nlats, glats);
        }
        return glats;
    }

    private GaussianLatitudes(int nlat) {
        int i;
        int i2;
        if (nlat == 0) {
            throw new IllegalArgumentException("nlats may not be zero");
        }
        int nzero = nlat / 2;
        double[] cosc = new double[nlat];
        double[] colat = new double[nlat];
        this.gaussw = new double[nlat];
        this.latd = new double[nlat];
        double[] sinc = new double[nlat];
        double[] wos2 = new double[nlat];
        for (int i3 = 0; i3 < nzero; ++i3) {
            cosc[i3] = Math.sin(((double)i3 + 0.5) * Math.PI / (double)nlat + 1.5707963267948966);
        }
        double FI = nlat;
        double FI1 = (double)nlat + 1.0;
        double A2 = FI * FI1 / Math.sqrt(4.0 * FI1 * FI1 - 1.0);
        double B = FI * FI1 / Math.sqrt(4.0 * FI * FI - 1.0);
        for (i2 = 0; i2 < nzero; ++i2) {
            double delta;
            int countIterations = 0;
            do {
                double G = this.lgord(cosc[i2], nlat);
                double GM = this.lgord(cosc[i2], nlat - 1);
                double GP = this.lgord(cosc[i2], nlat + 1);
                double denom = A2 * GP - B * GM;
                double GT = denom == 0.0 ? 0.0 : (cosc[i2] * cosc[i2] - 1.0) / denom;
                delta = G * GT;
                int n = i2;
                cosc[n] = cosc[n] - delta;
                ++countIterations;
            } while (!(Math.abs(delta) <= 1.0E-7));
            double C2 = 2.0 * (1.0 - cosc[i2] * cosc[i2]);
            double D = this.lgord(cosc[i2], nlat - 1);
            D = D * D * FI * FI;
            this.gaussw[i2] = D == 0.0 ? 0.0 : C2 * (FI - 0.5) / D;
        }
        for (i2 = 0; i2 < nzero; ++i2) {
            colat[i2] = Math.acos(cosc[i2]);
            sinc[i2] = Math.sin(colat[i2]);
            wos2[i2] = this.gaussw[i2] / (sinc[i2] * sinc[i2]);
        }
        int next = nzero;
        if (nlat % 2 != 0) {
            cosc[next] = 0.0;
            double C3 = 2.0;
            double D = this.lgord(cosc[next], nlat - 1);
            this.gaussw[next] = (D = D * D * FI * FI) == 0.0 ? 0.0 : C3 * (FI - 0.5) / D;
            colat[next] = 1.5707963267948966;
            sinc[next] = 1.0;
            wos2[next] = this.gaussw[next];
            ++next;
        }
        for (i = next; i < nlat; ++i) {
            cosc[i] = -cosc[nlat - i - 1];
            this.gaussw[i] = this.gaussw[nlat - i - 1];
            colat[i] = Math.PI - colat[nlat - i - 1];
            sinc[i] = sinc[nlat - i - 1];
            wos2[i] = wos2[nlat - i - 1];
        }
        for (i = 0; i < nlat; ++i) {
            this.latd[i] = Math.toDegrees(1.5707963267948966 - colat[i]);
        }
    }

    private double lgord(double cosc, int nlat) {
        double colat = Math.acos(cosc);
        double c = Math.sqrt(2.0);
        for (int k = 1; k <= nlat; ++k) {
            c *= Math.sqrt(1.0 - 1.0 / (double)(4 * k * k));
        }
        double FN = nlat;
        double ANG = FN * colat;
        double S1 = 0.0;
        double C4 = 1.0;
        double A2 = -1.0;
        double B = 0.0;
        for (int k = 0; k <= nlat; k += 2) {
            if (k == nlat) {
                C4 = 0.5 * C4;
            }
            S1 += C4 * Math.cos(ANG);
            double FK = k;
            ANG = colat * (FN - FK - 2.0);
            C4 = (A2 += 2.0) * (FN - (B += 1.0) + 1.0) / (B * (FN + FN - A2)) * C4;
        }
        return S1 * c;
    }
}

