/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.Platform;
import com.google.common.geometry.S2Point;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
public strictfp final class S1Angle
implements Comparable<S1Angle>,
Serializable {
    public static final S1Angle INFINITY = new S1Angle(Double.POSITIVE_INFINITY);
    public static final S1Angle ZERO = new S1Angle();
    private final double radians;

    public double radians() {
        return this.radians;
    }

    public double degrees() {
        return this.radians * 57.29577951308232;
    }

    public int e5() {
        return Ints.checkedCast(Math.round(this.degrees() * 100000.0));
    }

    public int e6() {
        return Ints.checkedCast(Math.round(this.degrees() * 1000000.0));
    }

    public int e7() {
        return Ints.checkedCast(Math.round(this.degrees() * 1.0E7));
    }

    public S1Angle() {
        this.radians = 0.0;
    }

    private S1Angle(double radians2) {
        this.radians = radians2;
    }

    public S1Angle(S2Point x, S2Point y) {
        this.radians = x.angle(y);
    }

    public boolean equals(Object that) {
        if (that instanceof S1Angle) {
            return this.radians == ((S1Angle)that).radians;
        }
        return false;
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.radians);
        return (int)(value ^ value >>> 32);
    }

    public boolean lessThan(S1Angle that) {
        return this.radians < that.radians;
    }

    public boolean greaterThan(S1Angle that) {
        return this.radians > that.radians;
    }

    public boolean lessOrEquals(S1Angle that) {
        return this.radians <= that.radians;
    }

    public boolean greaterOrEquals(S1Angle that) {
        return this.radians >= that.radians;
    }

    public static S1Angle max(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? right : left;
    }

    public static S1Angle min(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? left : right;
    }

    public static S1Angle radians(double radians2) {
        return new S1Angle(radians2);
    }

    public static S1Angle degrees(double degrees2) {
        return new S1Angle(degrees2 * (Math.PI / 180));
    }

    public static S1Angle e5(int e5) {
        return S1Angle.degrees((double)e5 * 1.0E-5);
    }

    public static S1Angle e6(int e6) {
        return S1Angle.degrees((double)e6 * 1.0E-6);
    }

    public static S1Angle e7(int e7) {
        return S1Angle.degrees((double)e7 * 1.0E-7);
    }

    public double distance(double radius) {
        return this.radians * radius;
    }

    public S1Angle neg() {
        return new S1Angle(-this.radians);
    }

    @CheckReturnValue
    public S1Angle add(S1Angle a) {
        return new S1Angle(this.radians + a.radians);
    }

    @CheckReturnValue
    public S1Angle sub(S1Angle a) {
        return new S1Angle(this.radians - a.radians);
    }

    @CheckReturnValue
    public S1Angle mul(double m3) {
        return new S1Angle(this.radians * m3);
    }

    @CheckReturnValue
    public S1Angle div(double d) {
        return new S1Angle(this.radians / d);
    }

    public double cos() {
        return Math.cos(this.radians);
    }

    public double sin() {
        return Math.sin(this.radians);
    }

    public double tan() {
        return Math.tan(this.radians);
    }

    @CheckReturnValue
    public S1Angle normalize() {
        boolean isNormalized;
        boolean bl = isNormalized = this.radians > -Math.PI && this.radians <= Math.PI;
        if (isNormalized) {
            return this;
        }
        double normalized = Platform.IEEEremainder(this.radians, Math.PI * 2);
        if (normalized <= -Math.PI) {
            normalized = Math.PI;
        }
        assert (normalized > -Math.PI);
        assert (normalized <= Math.PI);
        return new S1Angle(normalized);
    }

    public String toString() {
        return this.degrees() + "d";
    }

    @Override
    public int compareTo(S1Angle that) {
        return this.radians < that.radians ? -1 : (this.radians > that.radians ? 1 : 0);
    }

    public Builder toBuilder() {
        return new Builder().add(this);
    }

    public strictfp static final class Builder {
        private double radians;

        public Builder add(S1Angle angle) {
            this.radians += angle.radians;
            return this;
        }

        public Builder add(double radians2) {
            this.radians += radians2;
            return this;
        }

        public S1Angle build() {
            return new S1Angle(this.radians);
        }
    }
}

