/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class InfBufLine {
    private static final double EPS = 1.0E-13;
    private final double slope;
    private final double intercept;
    private final double buf;
    private final double distDenomInv;
    private static final int[] oppositeQuad = new int[]{-1, 3, 4, 1, 2};

    InfBufLine(double slope, Point point, double buf) {
        assert (!Double.isNaN(slope));
        this.slope = slope;
        if (Double.isInfinite(slope)) {
            this.intercept = point.getX();
            this.distDenomInv = Double.NaN;
        } else {
            this.intercept = point.getY() - slope * point.getX();
            this.distDenomInv = 1.0 / Math.sqrt(slope * slope + 1.0);
        }
        this.buf = buf;
    }

    SpatialRelation relate(Rectangle r, Point prC, Point scratch) {
        assert (r.getCenter().equals(prC));
        int cQuad = this.quadrant(prC);
        Point nearestP = scratch;
        InfBufLine.cornerByQuadrant(r, oppositeQuad[cQuad], nearestP);
        boolean nearestContains = this.contains(nearestP);
        if (nearestContains) {
            Point farthestP = scratch;
            nearestP = null;
            InfBufLine.cornerByQuadrant(r, cQuad, farthestP);
            boolean farthestContains = this.contains(farthestP);
            if (farthestContains) {
                return SpatialRelation.CONTAINS;
            }
            return SpatialRelation.INTERSECTS;
        }
        if (this.quadrant(nearestP) == cQuad) {
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.INTERSECTS;
    }

    boolean contains(Point p) {
        return this.distanceUnbuffered(p) <= this.buf + 1.0E-13;
    }

    public double distanceUnbuffered(Point c) {
        if (Double.isInfinite(this.slope)) {
            return Math.abs(c.getX() - this.intercept);
        }
        double num = Math.abs(c.getY() - this.slope * c.getX() - this.intercept);
        return num * this.distDenomInv;
    }

    public int quadrant(Point c) {
        boolean above;
        if (Double.isInfinite(this.slope)) {
            return c.getX() > this.intercept ? 1 : 2;
        }
        double yAtCinLine = this.slope * c.getX() + this.intercept;
        boolean bl = above = c.getY() >= yAtCinLine;
        if (this.slope > 0.0) {
            return above ? 2 : 4;
        }
        return above ? 1 : 3;
    }

    public static void cornerByQuadrant(Rectangle r, int cornerQuad, Point out) {
        double x = cornerQuad == 1 || cornerQuad == 4 ? r.getMaxX() : r.getMinX();
        double y = cornerQuad == 1 || cornerQuad == 2 ? r.getMaxY() : r.getMinY();
        out.reset(x, y);
    }

    public double getSlope() {
        return this.slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getBuf() {
        return this.buf;
    }

    public double getDistDenomInv() {
        return this.distDenomInv;
    }

    public String toString() {
        return "InfBufLine{buf=" + this.buf + ", intercept=" + this.intercept + ", slope=" + this.slope + '}';
    }
}

