/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
@Metrics(name="ShuffleClientMetrics", context="mapred")
public class ShuffleClientMetrics {
    @Metric
    private MutableCounterInt numFailedFetches;
    @Metric
    private MutableCounterInt numSuccessFetches;
    @Metric
    private MutableCounterLong numBytes;
    @Metric
    private MutableGaugeInt numThreadsBusy;

    private ShuffleClientMetrics() {
    }

    public static ShuffleClientMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.initialize("JobTracker");
        return ms.register("ShuffleClientMetrics-" + ThreadLocalRandom.current().nextInt(), null, new ShuffleClientMetrics());
    }

    public void inputBytes(long bytes) {
        this.numBytes.incr(bytes);
    }

    public void failedFetch() {
        this.numFailedFetches.incr();
    }

    public void successFetch() {
        this.numSuccessFetches.incr();
    }

    public void threadBusy() {
        this.numThreadsBusy.incr();
    }

    public void threadFree() {
        this.numThreadsBusy.decr();
    }
}

