/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.JSCompilerEntryPoint;
import org.apache.royale.compiler.clients.JSConfiguration;
import org.apache.royale.compiler.clients.MXMLC;
import org.apache.royale.compiler.clients.MXMLJSCNative;
import org.apache.royale.compiler.clients.MXMLJSCNode;
import org.apache.royale.compiler.clients.MXMLJSCNodeModule;
import org.apache.royale.compiler.clients.MXMLJSCRoyale;
import org.apache.royale.compiler.clients.MXMLJSCRoyaleCordova;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.ProblemQueryProvider;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CommandLineConfigurator;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationBuffer;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.config.ICompilerProblemSettings;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.internal.config.FlashBuilderConfigurator;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.internal.projects.ISourceFileHandler;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.projects.RoyaleProjectConfigurator;
import org.apache.royale.compiler.internal.units.SourceCompilationUnitFactory;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.SWF;
import org.apache.royale.swf.types.RGB;
import org.apache.royale.swf.types.Rect;
import org.apache.royale.utils.ArgumentUtil;
import org.apache.royale.utils.FilenameNormalization;

public class MXMLJSC
implements JSCompilerEntryPoint,
ProblemQueryProvider,
FlexTool {
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "file-specs";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    public static JSOutputType jsOutputType;
    protected Workspace workspace;
    protected RoyaleJSProject project;
    protected ProblemQuery problems;
    protected ISourceFileHandler asFileHandler;
    public JSConfiguration config;
    protected Configurator projectConfigurator;
    private ConfigurationBuffer configBuffer;
    private ICompilationUnit mainCU;
    protected ITarget target;
    protected ITargetSettings targetSettings;
    protected IJSApplication jsTarget;
    protected MXMLC mxmlc;
    protected JSCompilerEntryPoint lastCompiler;
    public boolean noLink;
    public OutputStream err;
    public Class<? extends Configuration> configurationClass = JSGoogConfiguration.class;

    public ProblemQuery getProblemQuery() {
        return this.problems;
    }

    public String getName() {
        return "MXMLC";
    }

    protected String getProgramName() {
        return "mxmljsc";
    }

    public int execute(String[] args) {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        return this.mainNoExit(args, problems, true);
    }

    public static void main(String[] args) {
        int exitCode = MXMLJSC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        System.out.println("MXMLJSC");
        for (String arg : args) {
            System.out.println(arg);
        }
        MXMLJSC mxmlc = new MXMLJSC();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    public MXMLJSC() {
        DefinitionBase.setPerformanceCachingEnabled((boolean)true);
        this.workspace = new Workspace();
        this.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate());
        this.project = new RoyaleJSProject(this.workspace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mainNoExit(String[] args, List<ICompilerProblem> problems, Boolean printProblems) {
        int exitCode = -1;
        try {
            exitCode = this._mainNoExit(ArgumentUtil.fixArgs((String[])args), problems);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        finally {
            if (problems != null && !problems.isEmpty() && printProblems.booleanValue()) {
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace, this.createProblemCategorizer());
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(problems);
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _mainNoExit(String[] args, List<ICompilerProblem> outProblems) {
        Iterator<String> iterator;
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            CompilerDiagnosticsConstants.diagnostics = this.config.getDiagnosticsLevel();
            if (!continueCompilation) {
                if (this.problems.hasFilteredProblems()) {
                    exitCode = ExitCode.FAILED_WITH_CONFIG_PROBLEMS;
                    return exitCode.code;
                }
                exitCode = ExitCode.PRINT_HELP;
                return exitCode.code;
            }
            iterator = this.config.getCompilerTargets().iterator();
        }
        catch (Exception e) {
            if (outProblems == null) {
                System.err.println(e.getMessage());
            } else {
                UnexpectedExceptionProblem unexpectedExceptionProblem = new UnexpectedExceptionProblem((Throwable)e);
                this.problems.add((ICompilerProblem)unexpectedExceptionProblem);
            }
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            return (int)exitCode;
        }
        finally {
            this.waitAndClose();
            if (outProblems == null) return exitCode.code;
            if (!this.problems.hasFilteredProblems()) return exitCode.code;
            Iterator iterator2 = this.problems.getFilteredProblems().iterator();
            while (iterator2.hasNext()) {
                ICompilerProblem problem = (ICompilerProblem)iterator2.next();
                outProblems.add(problem);
            }
            return exitCode.code;
        }
        block14: while (iterator.hasNext()) {
            String target = iterator.next();
            int result = 0;
            switch (JSTargetType.fromString(target)) {
                case SWF: {
                    this.mxmlc = new MXMLC();
                    this.mxmlc.configurationClass = this.configurationClass;
                    result = this.noLink ? this.mxmlc.mainCompileOnly(this.removeJSArgs(args), this.err) : this.mxmlc.mainNoExit(this.removeJSArgs(args));
                    if (result == 0 || result == 2) break;
                    this.problems.addAll((Iterable)this.mxmlc.problems.getProblems());
                    break block14;
                }
                case JS_ROYALE: {
                    MXMLJSCRoyale royale = new MXMLJSCRoyale();
                    this.lastCompiler = royale;
                    result = royale.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result == 0 || result == 2) break;
                    break block14;
                }
                case JS_ROYALE_CORDOVA: {
                    MXMLJSCRoyaleCordova royaleCordova = new MXMLJSCRoyaleCordova();
                    this.lastCompiler = royaleCordova;
                    result = royaleCordova.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result == 0 || result == 2) break;
                    break block14;
                }
                case JS_NODE: {
                    MXMLJSCNode node = new MXMLJSCNode();
                    this.lastCompiler = node;
                    result = node.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result == 0 || result == 2) break;
                    break block14;
                }
                case JS_NODE_MODULE: {
                    MXMLJSCNodeModule nodeModule = new MXMLJSCNodeModule();
                    this.lastCompiler = nodeModule;
                    result = nodeModule.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result == 0 || result == 2) break;
                    break block14;
                }
                case JS_NATIVE: {
                    MXMLJSCNative jsc = new MXMLJSCNative();
                    this.lastCompiler = jsc;
                    result = jsc.mainNoExit(this.removeASArgs(args), this.problems.getProblems(), false);
                    if (result != 0 && result != 2) break block14;
                }
            }
        }
        if (!this.problems.hasFilteredProblems()) return exitCode.code;
        if (this.problems.hasErrors()) {
            exitCode = ExitCode.FAILED_WITH_ERRORS;
            return exitCode.code;
        }
        exitCode = ExitCode.FAILED_WITH_PROBLEMS;
        return exitCode.code;
    }

    protected String[] removeJSArgs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-compiler.targets") || arg.startsWith("-closure-lib") || arg.startsWith("-remove-circulars") || arg.startsWith("-compiler.js-external-library-path") || arg.startsWith("-compiler.js-library-path") || arg.startsWith("-compiler.js-define") || arg.startsWith("-js-output") || arg.startsWith("-js-vector-emulation-class") || arg.startsWith("-externs-report") || arg.startsWith("-js-load-config") || arg.startsWith("-warn-public-vars") || arg.startsWith("-export-protected-symbols") || arg.startsWith("-source-map")) continue;
            list.add(arg);
        }
        return list.toArray(new String[0]);
    }

    protected String[] removeASArgs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        boolean hasJSLoadConfig = false;
        for (String arg : args) {
            if (!arg.startsWith("-js-load-config")) continue;
            hasJSLoadConfig = true;
        }
        if (!hasJSLoadConfig) {
            return args;
        }
        for (String arg : args) {
            if (arg.startsWith("-load-config")) continue;
            if (arg.startsWith("-js-load-config")) {
                arg = arg.substring(3);
            }
            list.add(arg);
        }
        return list.toArray(new String[0]);
    }

    protected boolean setupTargetFile() throws InterruptedException {
        File normalizedMainFile;
        String mainFileName = this.config.getTargetFile();
        String normalizedMainFileName = FilenameNormalization.normalize((String)mainFileName);
        SourceCompilationUnitFactory compilationUnitFactory = this.project.getSourceCompilationUnitFactory();
        if (compilationUnitFactory.canCreateCompilationUnit(normalizedMainFile = new File(normalizedMainFileName))) {
            this.project.addIncludeSourceFile(normalizedMainFile);
            List sourcePath = this.config.getCompilerSourcePath();
            String mainQName = null;
            if (sourcePath != null && !sourcePath.isEmpty()) {
                for (String path : sourcePath) {
                    String otherPath = new File(path).getAbsolutePath();
                    if (!mainFileName.startsWith(otherPath)) continue;
                    mainQName = mainFileName.substring(otherPath.length() + 1);
                    mainQName = mainQName.replaceAll("\\\\", "/");
                    if (!(mainQName = mainQName.replaceAll("\\/", ".")).endsWith(".as")) break;
                    mainQName = mainQName.substring(0, mainQName.length() - 3);
                    break;
                }
            }
            if (mainQName == null) {
                mainQName = FilenameUtils.getBaseName(mainFileName);
            }
            Collection mainFileCompilationUnits = this.workspace.getCompilationUnits(normalizedMainFileName, (ICompilerProject)this.project);
            this.mainCU = (ICompilationUnit)Iterables.getOnlyElement(mainFileCompilationUnits);
            this.config.setMainDefinition(mainQName);
        }
        Preconditions.checkNotNull(this.mainCU, "Main compilation unit can't be null");
        ITargetSettings settings = this.getTargetSettings();
        if (settings != null) {
            this.project.setTargetSettings(settings);
        }
        this.target = this.project.getBackend().createTarget(this.project, this.getTargetSettings(), null);
        return true;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(null);
        }
        return this.targetSettings;
    }

    protected Configurator createConfigurator() {
        return this.project.getBackend().createConfigurator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(String[] args) {
        this.projectConfigurator = new RoyaleProjectConfigurator(this.configurationClass);
        try {
            if (args.length == 0) {
                String usage = CommandLineConfigurator.brief((String)this.getProgramName(), (String)DEFAULT_VAR, (LocalizationManager)LocalizationManager.get(), (String)L10N_CONFIG_PREFIX);
                this.println(this.getStartMessage());
                if (usage != null) {
                    this.println(usage);
                }
            }
            if (this.useFlashBuilderProjectFiles(args)) {
                this.projectConfigurator.setConfiguration(FlashBuilderConfigurator.computeFlashBuilderArgs((String[])args, (String)this.getTargetType().getExtension()), DEFAULT_VAR);
            } else {
                this.projectConfigurator.setConfiguration(args, DEFAULT_VAR);
            }
            this.projectConfigurator.applyToProject((ICompilerProject)this.project);
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
            this.config = (JSConfiguration)this.projectConfigurator.getConfiguration();
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            if (this.configBuffer.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                boolean usage = false;
                return usage;
            }
            List helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                boolean bl = false;
                return bl;
            }
            for (String target : this.config.getCompilerTargets()) {
                JSTargetType jsTargetType = JSTargetType.fromString(target);
                if (jsTargetType != null) continue;
                String message = "configuration variable 'targets' must be one of the following: ";
                for (JSTargetType type : JSTargetType.values()) {
                    message = message + "'" + type.text + "', ";
                }
                message = message + "got '" + target + "'";
                ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, message);
                this.problems.add((ICompilerProblem)problem);
            }
            if (this.problems.hasErrors()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add((ICompilerProblem)problem);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.config == null) {
                this.config = new JSConfiguration();
                this.configBuffer = new ConfigurationBuffer(Configuration.class, Configuration.getAliases());
            }
        }
    }

    private boolean useFlashBuilderProjectFiles(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-fb") && !arg.equals("-use-flashbuilder-project-files")) continue;
            return true;
        }
        return false;
    }

    public void println(String msg) {
        System.out.println(msg);
    }

    protected String getStartMessage() {
        String message = "Apache Royale MXML and ActionScript Compiler (mxmlc)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            for (Object element : val.getArgs()) {
                String keyword = (String)element;
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage((String)this.getProgramName(), (String)DEFAULT_VAR, (ConfigurationBuffer)this.configBuffer, keywords, (LocalizationManager)LocalizationManager.get(), (String)L10N_CONFIG_PREFIX);
        this.println(this.getStartMessage());
        this.println(usages);
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    protected void waitAndClose() {
        this.workspace.startIdleState();
        try {
            this.workspace.close();
        }
        finally {
            this.workspace.endIdleState(Collections.emptyMap());
        }
    }

    protected void close() {
        this.workspace.close();
    }

    @Override
    public List<String> getSourceList() {
        if (this.lastCompiler != null) {
            return this.lastCompiler.getSourceList();
        }
        if (this.mxmlc != null) {
            return this.mxmlc.getSourceList();
        }
        return null;
    }

    @Override
    public String getMainSource() {
        if (this.lastCompiler != null) {
            return this.lastCompiler.getMainSource();
        }
        if (this.mxmlc != null) {
            return this.mxmlc.getMainSource();
        }
        return null;
    }

    public ISWF getSWFTarget() {
        SWF swf = new SWF();
        Rect rect = new Rect(this.getTargetSettings().getDefaultWidth(), this.getTargetSettings().getDefaultHeight());
        swf.setFrameSize(rect);
        swf.setBackgroundColor(new RGB(255, 255, 255));
        swf.setTopLevelClass(this.config.getTargetFile());
        return swf;
    }

    public long writeSWF(OutputStream output) {
        if (this.mxmlc != null) {
            return this.mxmlc.writeSWF(output);
        }
        return 0L;
    }

    public static boolean isFatalFailure(int code) {
        return code == ExitCode.FAILED_WITH_ERRORS.getCode() || code == ExitCode.FAILED_WITH_EXCEPTIONS.getCode() || code == ExitCode.FAILED_WITH_CONFIG_PROBLEMS.getCode();
    }

    private CompilerProblemCategorizer createProblemCategorizer() {
        ICompilerProblemSettings problemSettings = null;
        try {
            problemSettings = this.projectConfigurator.getCompilerProblemSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CompilerProblemCategorizer(problemSettings);
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(0),
        FAILED_WITH_ERRORS(3),
        FAILED_WITH_EXCEPTIONS(4),
        FAILED_WITH_CONFIG_PROBLEMS(5);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }

    public static enum JSTargetType {
        SWF("SWF"),
        JS_ROYALE("JSRoyale"),
        JS_ROYALE_CORDOVA("JSRoyaleCordova"),
        JS_NATIVE("JS"),
        JS_NODE("JSNode"),
        JS_NODE_MODULE("JSNodeModule");

        private String text;

        private JSTargetType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static JSTargetType fromString(String text) {
            for (JSTargetType jsTargetType : JSTargetType.values()) {
                if (!text.equalsIgnoreCase(jsTargetType.text)) continue;
                return jsTargetType;
            }
            return null;
        }
    }

    public static enum JSOutputType {
        AMD("amd"),
        ROYALE("royale"),
        GOOG("goog"),
        ROYALE_DUAL("royale_dual"),
        ROYALE_DITA("royale_dita"),
        JSC("jsc"),
        NODE("node");

        private String text;

        private JSOutputType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static JSOutputType fromString(String text) {
            for (JSOutputType jsOutputType : JSOutputType.values()) {
                if (!text.equalsIgnoreCase(jsOutputType.text)) continue;
                return jsOutputType;
            }
            return GOOG;
        }
    }
}

