/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.internal.graph.Graph;
import org.apache.royale.compiler.internal.graph.IGraphEdge;

public class SynchronizedGraph<V, E extends IGraphEdge<V>>
extends Graph<V, E> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public boolean addVertex(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.addVertex waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            boolean bl = super.addVertex(vertex);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.addVertex dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void removeVertex(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.removeVertex waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            super.removeVertex(vertex);
        }
        finally {
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.removeVertex dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E setEdge(V from, V to, E e) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.setEdge waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            E e2 = super.setEdge(e);
            return e2;
        }
        finally {
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.setEdge dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getEdge(V from, V to) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getEdge waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            Object e = super.getEdge(from, to);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getEdge dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getOutgoingEdges(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getOutgoingEdges waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.readLock().lock();
        try {
            Set result = super.getOutgoingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getOutgoingEdges dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getIncomingEdges(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getIncomingEdges waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.readLock().lock();
        try {
            Set result = super.getIncomingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getIncomingEdges dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    @Override
    public E removeEdge(E edge) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.removeEdge waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            E e = super.removeEdge(edge);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.removeEdge dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    @Override
    public Set<V> getVertices() {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getVertices waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.readLock().lock();
        try {
            Set result = super.getVertices();
            Set set = Collections.unmodifiableSet(new HashSet(result));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getVertices dpne with lock for " + this.getClass().getSimpleName());
            }
        }
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public Lock readLock() {
        return this.lock.readLock();
    }
}

