/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.driver.js.goog;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.ConfigurationInfo;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;

public class ASDocConfiguration
extends JSGoogConfiguration {
    private List<String> classes = new ArrayList<String>();
    private List<String> namespaces = new ArrayList<String>();
    private List<String> sources = new ArrayList<String>();
    private String examplesPath;
    private List<String> excludeClasses = new ArrayList<String>();
    private boolean excludeDependencies;
    private String footer;
    private boolean keepXML;
    private int leftFramesetWidth;
    private String mainTitle;
    private String packageDescriptionFile;
    private boolean skipXSL;
    private String templatesPath;
    private String windowTitle;
    private boolean restoreBuiltinClasses;
    private boolean lenient;
    private List<String> excludeSources = new ArrayList<String>();
    private boolean dateInFooter = true;
    private boolean includeAllForAsdoc;

    public ASDocConfiguration() {
        this.setDebug(true);
    }

    public static Map<String, String> getAliases() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("o", "output");
        map.put("dc", "doc-classes");
        map.put("dn", "doc-namespaces");
        map.put("ds", "doc-sources");
        map.putAll(Configuration.getAliases());
        return map;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void cfgDocClasses(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.classes.addAll(args);
    }

    public static ConfigurationInfo getDocClassesInfo() {
        return new ConfigurationInfo(-1, new String[]{"class"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public List<String> getIncludeClasses() {
        return this.classes;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void cfgDocNamespaces(ConfigurationValue val, List<String> DocNamespaces) {
        this.namespaces.addAll(DocNamespaces);
    }

    public static ConfigurationInfo getDocNamespacesInfo() {
        return new ConfigurationInfo(-1, new String[]{"uri"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public List<String> getIncludeNamespaces() {
        return this.namespaces;
    }

    public List<String> getDocSources() {
        return this.sources;
    }

    public void cfgDocSources(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.sources.addAll(args);
    }

    public static ConfigurationInfo getDocSourcesInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public List<String> getIncludeSources() {
        return this.sources;
    }

    public String getExamplesPath() {
        return this.examplesPath;
    }

    public void cfgExamplesPath(ConfigurationValue cv, String str) throws ConfigurationException {
        File file = new File(str);
        if (!file.isDirectory()) {
            throw new ConfigurationException.NotDirectory(str, cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.examplesPath = file.getAbsolutePath().replace('\\', '/');
    }

    public List<String> getExcludeClasses() {
        return this.excludeClasses;
    }

    public void cfgExcludeClasses(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.excludeClasses.addAll(args);
    }

    public static ConfigurationInfo getExcludeClassesInfo() {
        return new ConfigurationInfo(-1, new String[]{"class"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public boolean excludeDependencies() {
        return this.excludeDependencies;
    }

    public void cfgExcludeDependencies(ConfigurationValue val, boolean bool) {
        this.excludeDependencies = bool;
    }

    public String getFooter() {
        return this.footer;
    }

    public void cfgFooter(ConfigurationValue cv, String str) throws ConfigurationException {
        this.footer = str;
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            public boolean isGreedy() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public boolean keepXml() {
        return this.keepXML;
    }

    public void cfgKeepXml(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.keepXML = b;
    }

    public static ConfigurationInfo getKeepXmlInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public int getLeftFramesetWidth() {
        return this.leftFramesetWidth;
    }

    public void cfgLeftFramesetWidth(ConfigurationValue val, int left) {
        this.leftFramesetWidth = left;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public void cfgMainTitle(ConfigurationValue cv, String str) throws ConfigurationException {
        this.mainTitle = str;
    }

    public String getPackageDescriptionFile() {
        return this.packageDescriptionFile;
    }

    public void cfgPackageDescriptionFile(ConfigurationValue cv, String str) throws ConfigurationException {
        File file = new File(str);
        if (!file.exists() || file.isDirectory()) {
            throw new ConfigurationException.NotAFile(str, cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.packageDescriptionFile = file.getAbsolutePath().replace('\\', '/');
    }

    public boolean skipXsl() {
        return this.skipXSL;
    }

    public void cfgSkipXsl(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.skipXSL = b;
    }

    public static ConfigurationInfo getSkipXslInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void cfgTemplatesPath(ConfigurationValue val, String basedir) throws ConfigurationException {
        this.templatesPath = basedir;
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void cfgWindowTitle(ConfigurationValue cv, String str) throws ConfigurationException {
        this.windowTitle = str;
    }

    public boolean restoreBuiltinClasses() {
        return this.restoreBuiltinClasses;
    }

    public void cfgRestoreBuiltinClasses(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.restoreBuiltinClasses = b;
    }

    public static ConfigurationInfo getRestoreBuiltinClassesInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void cfgLenient(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.lenient = b;
    }

    public List<String> getExcludeSources() {
        return this.excludeSources;
    }

    public void cfgExcludeSources(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        for (String arg : args) {
            arg = arg.replace("\\", "/");
            this.excludeSources.add(arg);
        }
    }

    public static ConfigurationInfo getExcludeSourcesInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public boolean getDateInFooter() {
        return this.dateInFooter;
    }

    public void cfgDateInFooter(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.dateInFooter = b;
    }

    public boolean isIncludeAllForAsdoc() {
        return this.includeAllForAsdoc;
    }

    public void cfgIncludeAllForAsdoc(ConfigurationValue cv, boolean b) throws ConfigurationException {
        this.includeAllForAsdoc = b;
    }

    public static ConfigurationInfo getIncludeAllForAsdoc() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }
}

