////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package
{
    /**
     *  The FontAwesome5ProIconType class list all possible icons
	 *  for Font Awesome Pro version 5.x, excluding the Free version icons (FontAwesome5IconType class),
     *  found in https://fontawesome.com/ to use with the 
     *  FontAwesomeIcon class.
	 * 
     *
     *  @langversion 3.0
     *  @playerversion Flash 10.2
     *  @playerversion AIR 2.6
     *  @productversion Royale 0.9.11
     */
    public class FontAwesome5ProIconType
    {
        /**
		 *  constructor.
         * 
		 *  @langversion 3.0
		 *  @playerversion Flash 10.2
		 *  @playerversion AIR 2.6
		 *  @productversion Royale 0.9.11
		 */
		public function FontAwesome5ProIconType()
		{
			super();
		}

		public static const ABACUS:String = 'abacus';
		public static const ACORN:String = 'acorn';
		public static const AIR_CONDITIONER:String = 'air-conditioner';
		public static const ALARM_CLOCK:String = 'alarm-clock';
		public static const ALARM_EXCLAMATION:String = 'alarm-exclamation';
		public static const ALARM_PLUS:String = 'alarm-plus';
		public static const ALARM_SNOOZE:String = 'alarm-snooze';
		public static const ALBUM:String = 'album';
		public static const ALBUM_COLLECTION:String = 'album-collection';
		public static const ALICORN:String = 'alicorn';
		public static const ALIEN:String = 'alien';
		public static const ALIEN_MONSTER:String = 'alien-monster';
		public static const ALIGN_SLASH:String = 'align-slash';
		public static const AMP_GUITAR:String = 'amp-guitar';
		public static const ANALYTICS:String = 'analytics';
		public static const ANGEL:String = 'angel';
		public static const APPLE_CRATE:String = 'apple-crate';
		public static const ARROW_ALT_DOWN:String = 'arrow-alt-down';
		public static const ARROW_ALT_FROM_BOTTOM:String = 'arrow-alt-from-bottom';
		public static const ARROW_ALT_FROM_LEFT:String = 'arrow-alt-from-left';
		public static const ARROW_ALT_FROM_RIGHT:String = 'arrow-alt-from-right';
		public static const ARROW_ALT_FROM_TOP:String = 'arrow-alt-from-top';
		public static const ARROW_ALT_LEFT:String = 'arrow-alt-left';
		public static const ARROW_ALT_RIGHT:String = 'arrow-alt-right';
		public static const ARROW_ALT_SQUARE_DOWN:String = 'arrow-alt-square-down';
		public static const ARROW_ALT_SQUARE_LEFT:String = 'arrow-alt-square-left';
		public static const ARROW_ALT_SQUARE_RIGHT:String = 'arrow-alt-square-right';
		public static const ARROW_ALT_SQUARE_UP:String = 'arrow-alt-square-up';
		public static const ARROW_ALT_TO_BOTTOM:String = 'arrow-alt-to-bottom';
		public static const ARROW_ALT_TO_LEFT:String = 'arrow-alt-to-left';
		public static const ARROW_ALT_TO_RIGHT:String = 'arrow-alt-to-right';
		public static const ARROW_ALT_TO_TOP:String = 'arrow-alt-to-top';
		public static const ARROW_ALT_UP:String = 'arrow-alt-up';
		public static const ARROW_FROM_BOTTOM:String = 'arrow-from-bottom';
		public static const ARROW_FROM_LEFT:String = 'arrow-from-left';
		public static const ARROW_FROM_RIGHT:String = 'arrow-from-right';
		public static const ARROW_FROM_TOP:String = 'arrow-from-top';
		public static const ARROWS:String = 'arrows';
		public static const ARROWS_H:String = 'arrows-h';
		public static const ARROW_SQUARE_DOWN:String = 'arrow-square-down';
		public static const ARROW_SQUARE_LEFT:String = 'arrow-square-left';
		public static const ARROW_SQUARE_RIGHT:String = 'arrow-square-right';
		public static const ARROW_SQUARE_UP:String = 'arrow-square-up';
		public static const ARROWS_V:String = 'arrows-v';
		public static const ARROW_TO_BOTTOM:String = 'arrow-to-bottom';
		public static const ARROW_TO_LEFT:String = 'arrow-to-left';
		public static const ARROW_TO_RIGHT:String = 'arrow-to-right';
		public static const ARROW_TO_TOP:String = 'arrow-to-top';
		public static const ATOM_ALT:String = 'atom-alt';
		public static const AXE:String = 'axe';
		public static const AXE_BATTLE:String = 'axe-battle';
		public static const BACKPACK:String = 'backpack';
		public static const BADGE:String = 'badge';
		public static const BADGE_CHECK:String = 'badge-check';
		public static const BADGE_DOLLAR:String = 'badge-dollar';
		public static const BADGE_PERCENT:String = 'badge-percent';
		public static const BADGER_HONEY:String = 'badger-honey';
		public static const BADGE_SHERIFF:String = 'badge-sheriff';
		public static const BAGS_SHOPPING:String = 'bags-shopping';
		public static const BALLOT:String = 'ballot';
		public static const BALLOT_CHECK:String = 'ballot-check';
		public static const BALL_PILE:String = 'ball-pile';
		public static const BANJO:String = 'banjo';
		public static const BARCODE_ALT:String = 'barcode-alt';
		public static const BARCODE_READ:String = 'barcode-read';
		public static const BARCODE_SCAN:String = 'barcode-scan';
		public static const BASEBALL:String = 'baseball';
		public static const BASKETBALL_HOOP:String = 'basketball-hoop';
		public static const BAT:String = 'bat';
		public static const BATTERY_BOLT:String = 'battery-bolt';
		public static const BATTERY_SLASH:String = 'battery-slash';
		public static const BED_ALT:String = 'bed-alt';
		public static const BED_BUNK:String = 'bed-bunk';
		public static const BED_EMPTY:String = 'bed-empty';
		public static const BELL_EXCLAMATION:String = 'bell-exclamation';
		public static const BELL_ON:String = 'bell-on';
		public static const BELL_PLUS:String = 'bell-plus';
		public static const BELLS:String = 'bells';
		public static const BELL_SCHOOL:String = 'bell-school';
		public static const BELL_SCHOOL_SLASH:String = 'bell-school-slash';
		public static const BETAMAX:String = 'betamax';
		public static const BIKING_MOUNTAIN:String = 'biking-mountain';
		public static const BLANKET:String = 'blanket';
		public static const BLINDS:String = 'blinds';
		public static const BLINDS_OPEN:String = 'blinds-open';
		public static const BLINDS_RAISED:String = 'blinds-raised';
		public static const BONE_BREAK:String = 'bone-break';
		public static const BOOK_ALT:String = 'book-alt';
		public static const BOOK_HEART:String = 'book-heart';
		public static const BOOKS:String = 'books';
		public static const BOOKS_MEDICAL:String = 'books-medical';
		public static const BOOK_SPELLS:String = 'book-spells';
		public static const BOOK_USER:String = 'book-user';
		public static const BOOMBOX:String = 'boombox';
		public static const BOOT:String = 'boot';
		public static const BOOTH_CURTAIN:String = 'booth-curtain';
		public static const BORDER_BOTTOM:String = 'border-bottom';
		public static const BORDER_CENTER_H:String = 'border-center-h';
		public static const BORDER_CENTER_V:String = 'border-center-v';
		public static const BORDER_INNER:String = 'border-inner';
		public static const BORDER_LEFT:String = 'border-left';
		public static const BORDER_OUTER:String = 'border-outer';
		public static const BORDER_RIGHT:String = 'border-right';
		public static const BORDER_STYLE_ALT:String = 'border-style-alt';
		public static const BORDER_TOP:String = 'border-top';
		public static const BOW_ARROW:String = 'bow-arrow';
		public static const BOWLING_PINS:String = 'bowling-pins';
		public static const BOX_ALT:String = 'box-alt';
		public static const BOX_BALLOT:String = 'box-ballot';
		public static const BOX_CHECK:String = 'box-check';
		public static const BOXES_ALT:String = 'boxes-alt';
		public static const BOX_FRAGILE:String = 'box-fragile';
		public static const BOX_FULL:String = 'box-full';
		public static const BOX_HEART:String = 'box-heart';
		public static const BOXING_GLOVE:String = 'boxing-glove';
		public static const BOX_UP:String = 'box-up';
		public static const BOX_USD:String = 'box-usd';
		public static const BRACKETS:String = 'brackets';
		public static const BRACKETS_CURLY:String = 'brackets-curly';
		public static const BREAD_LOAF:String = 'bread-loaf';
		public static const BRING_FORWARD:String = 'bring-forward';
		public static const BRING_FRONT:String = 'bring-front';
		public static const BROWSER:String = 'browser';
		public static const BULLSEYE_ARROW:String = 'bullseye-arrow';
		public static const BULLSEYE_POINTER:String = 'bullseye-pointer';
		public static const BURGER_SODA:String = 'burger-soda';
		public static const BURRITO:String = 'burrito';
		public static const BUS_SCHOOL:String = 'bus-school';
		public static const CABINET_FILING:String = 'cabinet-filing';
		public static const CACTUS:String = 'cactus';
		public static const CALCULATOR_ALT:String = 'calculator-alt';
		public static const CALENDAR_EDIT:String = 'calendar-edit';
		public static const CALENDAR_EXCLAMATION:String = 'calendar-exclamation';
		public static const CALENDAR_STAR:String = 'calendar-star';
		public static const CAMCORDER:String = 'camcorder';
		public static const CAMERA_ALT:String = 'camera-alt';
		public static const CAMERA_HOME:String = 'camera-home';
		public static const CAMERA_MOVIE:String = 'camera-movie';
		public static const CAMERA_POLAROID:String = 'camera-polaroid';
		public static const CAMPFIRE:String = 'campfire';
		public static const CANDLE_HOLDER:String = 'candle-holder';
		public static const CANDY_CORN:String = 'candy-corn';
		public static const CARAVAN_ALT:String = 'caravan-alt';
		public static const CAR_BUILDING:String = 'car-building';
		public static const CAR_BUMP:String = 'car-bump';
		public static const CAR_BUS:String = 'car-bus';
		public static const CARET_CIRCLE_DOWN:String = 'caret-circle-down';
		public static const CARET_CIRCLE_LEFT:String = 'caret-circle-left';
		public static const CARET_CIRCLE_RIGHT:String = 'caret-circle-right';
		public static const CARET_CIRCLE_UP:String = 'caret-circle-up';
		public static const CAR_GARAGE:String = 'car-garage';
		public static const CAR_MECHANIC:String = 'car-mechanic';
		public static const CARS:String = 'cars';
		public static const CAR_TILT:String = 'car-tilt';
		public static const CAR_WASH:String = 'car-wash';
		public static const CASSETTE_TAPE:String = 'cassette-tape';
		public static const CAT_SPACE:String = 'cat-space';
		public static const CAULDRON:String = 'cauldron';
		public static const CCTV:String = 'cctv';
		public static const CHAIR_OFFICE:String = 'chair-office';
		public static const CHART_LINE_DOWN:String = 'chart-line-down';
		public static const CHART_NETWORK:String = 'chart-network';
		public static const CHART_PIE_ALT:String = 'chart-pie-alt';
		public static const CHART_SCATTER:String = 'chart-scatter';
		public static const CHEESEBURGER:String = 'cheeseburger';
		public static const CHEESE_SWISS:String = 'cheese-swiss';
		public static const CHESS_BISHOP_ALT:String = 'chess-bishop-alt';
		public static const CHESS_CLOCK:String = 'chess-clock';
		public static const CHESS_CLOCK_ALT:String = 'chess-clock-alt';
		public static const CHESS_KING_ALT:String = 'chess-king-alt';
		public static const CHESS_KNIGHT_ALT:String = 'chess-knight-alt';
		public static const CHESS_PAWN_ALT:String = 'chess-pawn-alt';
		public static const CHESS_QUEEN_ALT:String = 'chess-queen-alt';
		public static const CHESS_ROOK_ALT:String = 'chess-rook-alt';
		public static const CHEVRON_DOUBLE_DOWN:String = 'chevron-double-down';
		public static const CHEVRON_DOUBLE_LEFT:String = 'chevron-double-left';
		public static const CHEVRON_DOUBLE_RIGHT:String = 'chevron-double-right';
		public static const CHEVRON_DOUBLE_UP:String = 'chevron-double-up';
		public static const CHEVRON_SQUARE_DOWN:String = 'chevron-square-down';
		public static const CHEVRON_SQUARE_LEFT:String = 'chevron-square-left';
		public static const CHEVRON_SQUARE_RIGHT:String = 'chevron-square-right';
		public static const CHEVRON_SQUARE_UP:String = 'chevron-square-up';
		public static const CHIMNEY:String = 'chimney';
		public static const CLARINET:String = 'clarinet';
		public static const CLAW_MARKS:String = 'claw-marks';
		public static const CLIPBOARD_LIST_CHECK:String = 'clipboard-list-check';
		public static const CLIPBOARD_PRESCRIPTION:String = 'clipboard-prescription';
		public static const CLIPBOARD_USER:String = 'clipboard-user';
		public static const CLOUD_DOWNLOAD:String = 'cloud-download';
		public static const CLOUD_DRIZZLE:String = 'cloud-drizzle';
		public static const CLOUD_HAIL:String = 'cloud-hail';
		public static const CLOUD_HAIL_MIXED:String = 'cloud-hail-mixed';
		public static const CLOUD_MUSIC:String = 'cloud-music';
		public static const CLOUD_RAINBOW:String = 'cloud-rainbow';
		public static const CLOUDS:String = 'clouds';
		public static const CLOUD_SHOWERS:String = 'cloud-showers';
		public static const CLOUD_SLEET:String = 'cloud-sleet';
		public static const CLOUDS_MOON:String = 'clouds-moon';
		public static const CLOUD_SNOW:String = 'cloud-snow';
		public static const CLOUDS_SUN:String = 'clouds-sun';
		public static const CLOUD_UPLOAD:String = 'cloud-upload';
		public static const CLUB:String = 'club';
		public static const CODE_COMMIT:String = 'code-commit';
		public static const CODE_MERGE:String = 'code-merge';
		public static const COFFEE_POT:String = 'coffee-pot';
		public static const COFFEE_TOGO:String = 'coffee-togo';
		public static const COFFIN:String = 'coffin';
		public static const COFFIN_CROSS:String = 'coffin-cross';
		public static const COIN:String = 'coin';
		public static const COMET:String = 'comet';
		public static const COMMENT_ALT_CHECK:String = 'comment-alt-check';
		public static const COMMENT_ALT_DOLLAR:String = 'comment-alt-dollar';
		public static const COMMENT_ALT_DOTS:String = 'comment-alt-dots';
		public static const COMMENT_ALT_EDIT:String = 'comment-alt-edit';
		public static const COMMENT_ALT_EXCLAMATION:String = 'comment-alt-exclamation';
		public static const COMMENT_ALT_LINES:String = 'comment-alt-lines';
		public static const COMMENT_ALT_MEDICAL:String = 'comment-alt-medical';
		public static const COMMENT_ALT_MINUS:String = 'comment-alt-minus';
		public static const COMMENT_ALT_MUSIC:String = 'comment-alt-music';
		public static const COMMENT_ALT_PLUS:String = 'comment-alt-plus';
		public static const COMMENT_ALT_SLASH:String = 'comment-alt-slash';
		public static const COMMENT_ALT_SMILE:String = 'comment-alt-smile';
		public static const COMMENT_ALT_TIMES:String = 'comment-alt-times';
		public static const COMMENT_CHECK:String = 'comment-check';
		public static const COMMENT_EDIT:String = 'comment-edit';
		public static const COMMENT_EXCLAMATION:String = 'comment-exclamation';
		public static const COMMENT_LINES:String = 'comment-lines';
		public static const COMMENT_MINUS:String = 'comment-minus';
		public static const COMMENT_MUSIC:String = 'comment-music';
		public static const COMMENT_PLUS:String = 'comment-plus';
		public static const COMMENTS_ALT:String = 'comments-alt';
		public static const COMMENTS_ALT_DOLLAR:String = 'comments-alt-dollar';
		public static const COMMENT_SMILE:String = 'comment-smile';
		public static const COMMENT_TIMES:String = 'comment-times';
		public static const COMPASS_SLASH:String = 'compass-slash';
		public static const COMPRESS_WIDE:String = 'compress-wide';
		public static const COMPUTER_CLASSIC:String = 'computer-classic';
		public static const COMPUTER_SPEAKER:String = 'computer-speaker';
		public static const CONSTRUCTION:String = 'construction';
		public static const CONTAINER_STORAGE:String = 'container-storage';
		public static const CONVEYOR_BELT:String = 'conveyor-belt';
		public static const CONVEYOR_BELT_ALT:String = 'conveyor-belt-alt';
		public static const CORN:String = 'corn';
		public static const COW:String = 'cow';
		public static const COWBELL:String = 'cowbell';
		public static const COWBELL_MORE:String = 'cowbell-more';
		public static const CREDIT_CARD_BLANK:String = 'credit-card-blank';
		public static const CREDIT_CARD_FRONT:String = 'credit-card-front';
		public static const CRICKET:String = 'cricket';
		public static const CROISSANT:String = 'croissant';
		public static const CRUTCHES:String = 'crutches';
		public static const CURLING:String = 'curling';
		public static const DAGGER:String = 'dagger';
		public static const DEBUG:String = 'debug';
		public static const DEER:String = 'deer';
		public static const DEER_RUDOLPH:String = 'deer-rudolph';
		public static const DESKTOP_ALT:String = 'desktop-alt';
		public static const DEWPOINT:String = 'dewpoint';
		public static const DIAMOND:String = 'diamond';
		public static const DICE_D10:String = 'dice-d10';
		public static const DICE_D12:String = 'dice-d12';
		public static const DICE_D4:String = 'dice-d4';
		public static const DICE_D8:String = 'dice-d8';
		public static const DIGGING:String = 'digging';
		public static const DIPLOMA:String = 'diploma';
		public static const DISC_DRIVE:String = 'disc-drive';
		public static const DOG_LEASHED:String = 'dog-leashed';
		public static const DOLLY_EMPTY:String = 'dolly-empty';
		public static const DOLLY_FLATBED_ALT:String = 'dolly-flatbed-alt';
		public static const DOLLY_FLATBED_EMPTY:String = 'dolly-flatbed-empty';
		public static const DO_NOT_ENTER:String = 'do-not-enter';
		public static const DRAW_CIRCLE:String = 'draw-circle';
		public static const DRAW_SQUARE:String = 'draw-square';
		public static const DREIDEL:String = 'dreidel';
		public static const DRONE:String = 'drone';
		public static const DRONE_ALT:String = 'drone-alt';
		public static const DRUMSTICK:String = 'drumstick';
		public static const DRYER:String = 'dryer';
		public static const DRYER_ALT:String = 'dryer-alt';
		public static const DUCK:String = 'duck';
		public static const EAR:String = 'ear';
		public static const EAR_MUFFS:String = 'ear-muffs';
		public static const ECLIPSE:String = 'eclipse';
		public static const ECLIPSE_ALT:String = 'eclipse-alt';
		public static const EGG_FRIED:String = 'egg-fried';
		public static const ELEPHANT:String = 'elephant';
		public static const ELLIPSIS_H_ALT:String = 'ellipsis-h-alt';
		public static const ELLIPSIS_V_ALT:String = 'ellipsis-v-alt';
		public static const EMPTY_SET:String = 'empty-set';
		public static const ENGINE_WARNING:String = 'engine-warning';
		public static const ENVELOPE_OPEN_DOLLAR:String = 'envelope-open-dollar';
		public static const EXCHANGE:String = 'exchange';
		public static const EXCLAMATION_SQUARE:String = 'exclamation-square';
		public static const EXPAND_ARROWS:String = 'expand-arrows';
		public static const EXPAND_WIDE:String = 'expand-wide';
		public static const EXTERNAL_LINK:String = 'external-link';
		public static const EXTERNAL_LINK_SQUARE:String = 'external-link-square';
		public static const EYE_EVIL:String = 'eye-evil';
		public static const FAN_TABLE:String = 'fan-table';
		public static const FARM:String = 'farm';
		public static const FAUCET_DRIP:String = 'faucet-drip';
		public static const FIELD_HOCKEY:String = 'field-hockey';
		public static const FILE_CERTIFICATE:String = 'file-certificate';
		public static const FILE_CHART_LINE:String = 'file-chart-line';
		public static const FILE_CHART_PIE:String = 'file-chart-pie';
		public static const FILE_CHECK:String = 'file-check';
		public static const FILE_EDIT:String = 'file-edit';
		public static const FILE_EXCLAMATION:String = 'file-exclamation';
		public static const FILE_MINUS:String = 'file-minus';
		public static const FILE_MUSIC:String = 'file-music';
		public static const FILE_PLUS:String = 'file-plus';
		public static const FILE_SEARCH:String = 'file-search';
		public static const FILES_MEDICAL:String = 'files-medical';
		public static const FILE_SPREADSHEET:String = 'file-spreadsheet';
		public static const FILE_TIMES:String = 'file-times';
		public static const FILE_USER:String = 'file-user';
		public static const FILM_ALT:String = 'film-alt';
		public static const FILM_CANISTER:String = 'film-canister';
		public static const FIREPLACE:String = 'fireplace';
		public static const FIRE_SMOKE:String = 'fire-smoke';
		public static const FISH_COOKED:String = 'fish-cooked';
		public static const FLAG_ALT:String = 'flag-alt';
		public static const FLAME:String = 'flame';
		public static const FLASHLIGHT:String = 'flashlight';
		public static const FLASK_POISON:String = 'flask-poison';
		public static const FLASK_POTION:String = 'flask-potion';
		public static const FLOWER:String = 'flower';
		public static const FLOWER_DAFFODIL:String = 'flower-daffodil';
		public static const FLOWER_TULIP:String = 'flower-tulip';
		public static const FLUTE:String = 'flute';
		public static const FLUX_CAPACITOR:String = 'flux-capacitor';
		public static const FOG:String = 'fog';
		public static const FOLDER_DOWNLOAD:String = 'folder-download';
		public static const FOLDERS:String = 'folders';
		public static const FOLDER_TIMES:String = 'folder-times';
		public static const FOLDER_TREE:String = 'folder-tree';
		public static const FOLDER_UPLOAD:String = 'folder-upload';
		public static const FONT_CASE:String = 'font-case';
		public static const FOOTBALL_HELMET:String = 'football-helmet';
		public static const FORKLIFT:String = 'forklift';
		public static const FRAGILE:String = 'fragile';
		public static const FRENCH_FRIES:String = 'french-fries';
		public static const FROSTY_HEAD:String = 'frosty-head';
		public static const FUNCTION:String = 'function';
		public static const GALAXY:String = 'galaxy';
		public static const GAME_BOARD:String = 'game-board';
		public static const GAME_BOARD_ALT:String = 'game-board-alt';
		public static const GAME_CONSOLE_HANDHELD:String = 'game-console-handheld';
		public static const GAMEPAD_ALT:String = 'gamepad-alt';
		public static const GARAGE:String = 'garage';
		public static const GARAGE_CAR:String = 'garage-car';
		public static const GARAGE_OPEN:String = 'garage-open';
		public static const GAS_PUMP_SLASH:String = 'gas-pump-slash';
		public static const GIFT_CARD:String = 'gift-card';
		public static const GINGERBREAD_MAN:String = 'gingerbread-man';
		public static const GLASS:String = 'glass';
		public static const GLASS_CHAMPAGNE:String = 'glass-champagne';
		public static const GLASS_CITRUS:String = 'glass-citrus';
		public static const GLASSES_ALT:String = 'glasses-alt';
		public static const GLASS_WHISKEY_ROCKS:String = 'glass-whiskey-rocks';
		public static const GLOBE_SNOW:String = 'globe-snow';
		public static const GLOBE_STAND:String = 'globe-stand';
		public static const GOLF_CLUB:String = 'golf-club';
		public static const GRAMOPHONE:String = 'gramophone';
		public static const GUITAR_ELECTRIC:String = 'guitar-electric';
		public static const GUITARS:String = 'guitars';
		public static const H1:String = 'h1';
		public static const H2:String = 'h2';
		public static const H3:String = 'h3';
		public static const H4:String = 'h4';
		public static const HAMMER_WAR:String = 'hammer-war';
		public static const HAND_HEART:String = 'hand-heart';
		public static const HAND_HOLDING_BOX:String = 'hand-holding-box';
		public static const HAND_HOLDING_MAGIC:String = 'hand-holding-magic';
		public static const HAND_HOLDING_SEEDLING:String = 'hand-holding-seedling';
		public static const HAND_RECEIVING:String = 'hand-receiving';
		public static const HANDSHAKE_ALT:String = 'handshake-alt';
		public static const HANDS_HEART:String = 'hands-heart';
		public static const HANDS_USD:String = 'hands-usd';
		public static const HAT_CHEF:String = 'hat-chef';
		public static const HAT_SANTA:String = 'hat-santa';
		public static const HAT_WINTER:String = 'hat-winter';
		public static const HAT_WITCH:String = 'hat-witch';
		public static const HEAD_SIDE:String = 'head-side';
		public static const HEAD_SIDE_BRAIN:String = 'head-side-brain';
		public static const HEAD_SIDE_HEADPHONES:String = 'head-side-headphones';
		public static const HEAD_SIDE_MEDICAL:String = 'head-side-medical';
		public static const HEAD_VR:String = 'head-vr';
		public static const HEART_CIRCLE:String = 'heart-circle';
		public static const HEART_RATE:String = 'heart-rate';
		public static const HEART_SQUARE:String = 'heart-square';
		public static const HEAT:String = 'heat';
		public static const HELMET_BATTLE:String = 'helmet-battle';
		public static const HEXAGON:String = 'hexagon';
		public static const HOCKEY_MASK:String = 'hockey-mask';
		public static const HOCKEY_STICKS:String = 'hockey-sticks';
		public static const HOME_ALT:String = 'home-alt';
		public static const HOME_HEART:String = 'home-heart';
		public static const HOME_LG:String = 'home-lg';
		public static const HOME_LG_ALT:String = 'home-lg-alt';
		public static const HOOD_CLOAK:String = 'hood-cloak';
		public static const HORIZONTAL_RULE:String = 'horizontal-rule';
		public static const HORSE_SADDLE:String = 'horse-saddle';
		public static const HOSPITALS:String = 'hospitals';
		public static const HOUSE:String = 'house';
		public static const HOUSE_DAY:String = 'house-day';
		public static const HOUSE_FLOOD:String = 'house-flood';
		public static const HOUSE_LEAVE:String = 'house-leave';
		public static const HOUSE_NIGHT:String = 'house-night';
		public static const HOUSE_RETURN:String = 'house-return';
		public static const HOUSE_SIGNAL:String = 'house-signal';
		public static const HUMIDITY:String = 'humidity';
		public static const HURRICANE:String = 'hurricane';
		public static const ICE_SKATE:String = 'ice-skate';
		public static const ICONS_ALT:String = 'icons-alt';
		public static const IMAGE_POLAROID:String = 'image-polaroid';
		public static const INBOX_IN:String = 'inbox-in';
		public static const INBOX_OUT:String = 'inbox-out';
		public static const INDUSTRY_ALT:String = 'industry-alt';
		public static const INFO_SQUARE:String = 'info-square';
		public static const INHALER:String = 'inhaler';
		public static const INTEGRAL:String = 'integral';
		public static const INTERSECTION:String = 'intersection';
		public static const INVENTORY:String = 'inventory';
		public static const ISLAND_TROPICAL:String = 'island-tropical';
		public static const JACK_O_LANTERN:String = 'jack-o-lantern';
		public static const JOYSTICK:String = 'joystick';
		public static const JUG:String = 'jug';
		public static const KAZOO:String = 'kazoo';
		public static const KERNING:String = 'kerning';
		public static const KEYNOTE:String = 'keynote';
		public static const KEY_SKELETON:String = 'key-skeleton';
		public static const KIDNEYS:String = 'kidneys';
		public static const KITE:String = 'kite';
		public static const KNIFE_KITCHEN:String = 'knife-kitchen';
		public static const LAMBDA:String = 'lambda';
		public static const LAMP:String = 'lamp';
		public static const LAMP_DESK:String = 'lamp-desk';
		public static const LAMP_FLOOR:String = 'lamp-floor';
		public static const LANDMARK_ALT:String = 'landmark-alt';
		public static const LASSO:String = 'lasso';
		public static const LAYER_MINUS:String = 'layer-minus';
		public static const LAYER_PLUS:String = 'layer-plus';
		public static const LEAF_HEART:String = 'leaf-heart';
		public static const LEAF_MAPLE:String = 'leaf-maple';
		public static const LEAF_OAK:String = 'leaf-oak';
		public static const LEVEL_DOWN:String = 'level-down';
		public static const LEVEL_UP:String = 'level-up';
		public static const LIGHTBULB_DOLLAR:String = 'lightbulb-dollar';
		public static const LIGHTBULB_EXCLAMATION:String = 'lightbulb-exclamation';
		public static const LIGHTBULB_ON:String = 'lightbulb-on';
		public static const LIGHTBULB_SLASH:String = 'lightbulb-slash';
		public static const LIGHT_CEILING:String = 'light-ceiling';
		public static const LIGHTS_HOLIDAY:String = 'lights-holiday';
		public static const LIGHT_SWITCH:String = 'light-switch';
		public static const LIGHT_SWITCH_OFF:String = 'light-switch-off';
		public static const LIGHT_SWITCH_ON:String = 'light-switch-on';
		public static const LINE_COLUMNS:String = 'line-columns';
		public static const LINE_HEIGHT:String = 'line-height';
		public static const LIPS:String = 'lips';
		public static const LIST_MUSIC:String = 'list-music';
		public static const LOCATION:String = 'location';
		public static const LOCATION_CIRCLE:String = 'location-circle';
		public static const LOCATION_SLASH:String = 'location-slash';
		public static const LOCK_ALT:String = 'lock-alt';
		public static const LOCK_OPEN_ALT:String = 'lock-open-alt';
		public static const LONG_ARROW_DOWN:String = 'long-arrow-down';
		public static const LONG_ARROW_LEFT:String = 'long-arrow-left';
		public static const LONG_ARROW_RIGHT:String = 'long-arrow-right';
		public static const LONG_ARROW_UP:String = 'long-arrow-up';
		public static const LOVESEAT:String = 'loveseat';
		public static const LUCHADOR:String = 'luchador';
		public static const MACE:String = 'mace';
		public static const MAILBOX:String = 'mailbox';
		public static const MANDOLIN:String = 'mandolin';
		public static const MAP_MARKER_ALT_SLASH:String = 'map-marker-alt-slash';
		public static const MAP_MARKER_CHECK:String = 'map-marker-check';
		public static const MAP_MARKER_EDIT:String = 'map-marker-edit';
		public static const MAP_MARKER_EXCLAMATION:String = 'map-marker-exclamation';
		public static const MAP_MARKER_MINUS:String = 'map-marker-minus';
		public static const MAP_MARKER_PLUS:String = 'map-marker-plus';
		public static const MAP_MARKER_QUESTION:String = 'map-marker-question';
		public static const MAP_MARKER_SLASH:String = 'map-marker-slash';
		public static const MAP_MARKER_SMILE:String = 'map-marker-smile';
		public static const MAP_MARKER_TIMES:String = 'map-marker-times';
		public static const MEAT:String = 'meat';
		public static const MEGAPHONE:String = 'megaphone';
		public static const MICROPHONE_STAND:String = 'microphone-stand';
		public static const MICROWAVE:String = 'microwave';
		public static const MIND_SHARE:String = 'mind-share';
		public static const MINUS_HEXAGON:String = 'minus-hexagon';
		public static const MINUS_OCTAGON:String = 'minus-octagon';
		public static const MISTLETOE:String = 'mistletoe';
		public static const MOBILE_ANDROID:String = 'mobile-android';
		public static const MOBILE_ANDROID_ALT:String = 'mobile-android-alt';
		public static const MONEY_CHECK_EDIT:String = 'money-check-edit';
		public static const MONEY_CHECK_EDIT_ALT:String = 'money-check-edit-alt';
		public static const MONITOR_HEART_RATE:String = 'monitor-heart-rate';
		public static const MONKEY:String = 'monkey';
		public static const MOON_CLOUD:String = 'moon-cloud';
		public static const MOON_STARS:String = 'moon-stars';
		public static const MOUNTAINS:String = 'mountains';
		public static const MOUSE_ALT:String = 'mouse-alt';
		public static const MP3_PLAYER:String = 'mp3-player';
		public static const MUG:String = 'mug';
		public static const MUG_MARSHMALLOWS:String = 'mug-marshmallows';
		public static const MUG_TEA:String = 'mug-tea';
		public static const MUSIC_ALT:String = 'music-alt';
		public static const MUSIC_ALT_SLASH:String = 'music-alt-slash';
		public static const MUSIC_SLASH:String = 'music-slash';
		public static const NARWHAL:String = 'narwhal';
		public static const OCTAGON:String = 'octagon';
		public static const OIL_TEMP:String = 'oil-temp';
		public static const OMEGA:String = 'omega';
		public static const ORNAMENT:String = 'ornament';
		public static const OUTLET:String = 'outlet';
		public static const OVEN:String = 'oven';
		public static const OVERLINE:String = 'overline';
		public static const PAGE_BREAK:String = 'page-break';
		public static const PAINT_BRUSH_ALT:String = 'paint-brush-alt';
		public static const PALLET_ALT:String = 'pallet-alt';
		public static const PARAGRAPH_RTL:String = 'paragraph-rtl';
		public static const PARKING_CIRCLE:String = 'parking-circle';
		public static const PARKING_CIRCLE_SLASH:String = 'parking-circle-slash';
		public static const PARKING_SLASH:String = 'parking-slash';
		public static const PAW_ALT:String = 'paw-alt';
		public static const PAW_CLAWS:String = 'paw-claws';
		public static const PEGASUS:String = 'pegasus';
		public static const PENCIL:String = 'pencil';
		public static const PENCIL_PAINTBRUSH:String = 'pencil-paintbrush';
		public static const PENNANT:String = 'pennant';
		public static const PERSON_CARRY:String = 'person-carry';
		public static const PERSON_DOLLY:String = 'person-dolly';
		public static const PERSON_DOLLY_EMPTY:String = 'person-dolly-empty';
		public static const PERSON_SIGN:String = 'person-sign';
		public static const PHONE_LAPTOP:String = 'phone-laptop';
		public static const PHONE_OFFICE:String = 'phone-office';
		public static const PHONE_PLUS:String = 'phone-plus';
		public static const PHONE_ROTARY:String = 'phone-rotary';
		public static const PI:String = 'pi';
		public static const PIANO:String = 'piano';
		public static const PIANO_KEYBOARD:String = 'piano-keyboard';
		public static const PIE:String = 'pie';
		public static const PIG:String = 'pig';
		public static const PIZZA:String = 'pizza';
		public static const PLANE_ALT:String = 'plane-alt';
		public static const PLANET_MOON:String = 'planet-moon';
		public static const PLANET_RINGED:String = 'planet-ringed';
		public static const PLUS_HEXAGON:String = 'plus-hexagon';
		public static const PLUS_OCTAGON:String = 'plus-octagon';
		public static const PODIUM:String = 'podium';
		public static const PODIUM_STAR:String = 'podium-star';
		public static const POLICE_BOX:String = 'police-box';
		public static const POLL_PEOPLE:String = 'poll-people';
		public static const POPCORN:String = 'popcorn';
		public static const PORTAL_ENTER:String = 'portal-enter';
		public static const PORTAL_EXIT:String = 'portal-exit';
		public static const PRESENTATION:String = 'presentation';
		public static const PRINT_SEARCH:String = 'print-search';
		public static const PRINT_SLASH:String = 'print-slash';
		public static const PROJECTOR:String = 'projector';
		public static const PUMPKIN:String = 'pumpkin';
		public static const QUESTION_SQUARE:String = 'question-square';
		public static const RABBIT:String = 'rabbit';
		public static const RABBIT_FAST:String = 'rabbit-fast';
		public static const RACQUET:String = 'racquet';
		public static const RADAR:String = 'radar';
		public static const RADIO:String = 'radio';
		public static const RADIO_ALT:String = 'radio-alt';
		public static const RAINDROPS:String = 'raindrops';
		public static const RAM:String = 'ram';
		public static const RAMP_LOADING:String = 'ramp-loading';
		public static const RAYGUN:String = 'raygun';
		public static const RECTANGLE_LANDSCAPE:String = 'rectangle-landscape';
		public static const RECTANGLE_PORTRAIT:String = 'rectangle-portrait';
		public static const RECTANGLE_WIDE:String = 'rectangle-wide';
		public static const REFRIGERATOR:String = 'refrigerator';
		public static const REPEAT:String = 'repeat';
		public static const REPEAT_1:String = 'repeat-1';
		public static const REPEAT_1_ALT:String = 'repeat-1-alt';
		public static const REPEAT_ALT:String = 'repeat-alt';
		public static const RETWEET_ALT:String = 'retweet-alt';
		public static const RINGS_WEDDING:String = 'rings-wedding';
		public static const ROCKET_LAUNCH:String = 'rocket-launch';
		public static const ROUTE_HIGHWAY:String = 'route-highway';
		public static const ROUTE_INTERSTATE:String = 'route-interstate';
		public static const ROUTER:String = 'router';
		public static const RULER_TRIANGLE:String = 'ruler-triangle';
		public static const RV:String = 'rv';
		public static const SACK:String = 'sack';
		public static const SACK_DOLLAR:String = 'sack-dollar';
		public static const SALAD:String = 'salad';
		public static const SANDWICH:String = 'sandwich';
		public static const SAUSAGE:String = 'sausage';
		public static const SAX_HOT:String = 'sax-hot';
		public static const SAXOPHONE:String = 'saxophone';
		public static const SCALPEL:String = 'scalpel';
		public static const SCALPEL_PATH:String = 'scalpel-path';
		public static const SCANNER:String = 'scanner';
		public static const SCANNER_IMAGE:String = 'scanner-image';
		public static const SCANNER_KEYBOARD:String = 'scanner-keyboard';
		public static const SCANNER_TOUCHSCREEN:String = 'scanner-touchscreen';
		public static const SCARECROW:String = 'scarecrow';
		public static const SCARF:String = 'scarf';
		public static const SCROLL_OLD:String = 'scroll-old';
		public static const SCRUBBER:String = 'scrubber';
		public static const SCYTHE:String = 'scythe';
		public static const SEND_BACK:String = 'send-back';
		public static const SEND_BACKWARD:String = 'send-backward';
		public static const SENSOR:String = 'sensor';
		public static const SENSOR_ALERT:String = 'sensor-alert';
		public static const SENSOR_FIRE:String = 'sensor-fire';
		public static const SENSOR_ON:String = 'sensor-on';
		public static const SENSOR_SMOKE:String = 'sensor-smoke';
		public static const SHARE_ALL:String = 'share-all';
		public static const SHEEP:String = 'sheep';
		public static const SHIELD:String = 'shield';
		public static const SHIELD_CHECK:String = 'shield-check';
		public static const SHIELD_CROSS:String = 'shield-cross';
		public static const SHIPPING_TIMED:String = 'shipping-timed';
		public static const SHISH_KEBAB:String = 'shish-kebab';
		public static const SHOVEL:String = 'shovel';
		public static const SHOVEL_SNOW:String = 'shovel-snow';
		public static const SHREDDER:String = 'shredder';
		public static const SHUTTLECOCK:String = 'shuttlecock';
		public static const SICKLE:String = 'sickle';
		public static const SIGMA:String = 'sigma';
		public static const SIGNAL_1:String = 'signal-1';
		public static const SIGNAL_2:String = 'signal-2';
		public static const SIGNAL_3:String = 'signal-3';
		public static const SIGNAL_4:String = 'signal-4';
		public static const SIGNAL_ALT:String = 'signal-alt';
		public static const SIGNAL_ALT_1:String = 'signal-alt-1';
		public static const SIGNAL_ALT_2:String = 'signal-alt-2';
		public static const SIGNAL_ALT_3:String = 'signal-alt-3';
		public static const SIGNAL_ALT_SLASH:String = 'signal-alt-slash';
		public static const SIGNAL_SLASH:String = 'signal-slash';
		public static const SIGNAL_STREAM:String = 'signal-stream';
		public static const SIGN_IN:String = 'sign-in';
		public static const SIGN_OUT:String = 'sign-out';
		public static const SIREN:String = 'siren';
		public static const SIREN_ON:String = 'siren-on';
		public static const SKELETON:String = 'skeleton';
		public static const SKI_JUMP:String = 'ski-jump';
		public static const SKI_LIFT:String = 'ski-lift';
		public static const SKULL_COW:String = 'skull-cow';
		public static const SLEDDING:String = 'sledding';
		public static const SLIDERS_H_SQUARE:String = 'sliders-h-square';
		public static const SLIDERS_V:String = 'sliders-v';
		public static const SLIDERS_V_SQUARE:String = 'sliders-v-square';
		public static const SMILE_PLUS:String = 'smile-plus';
		public static const SMOKE:String = 'smoke';
		public static const SNAKE:String = 'snake';
		public static const SNOOZE:String = 'snooze';
		public static const SNOW_BLOWING:String = 'snow-blowing';
		public static const SNOWFLAKES:String = 'snowflakes';
		public static const SNOWMOBILE:String = 'snowmobile';
		public static const SOLAR_SYSTEM:String = 'solar-system';
		public static const SORT_ALT:String = 'sort-alt';
		public static const SORT_CIRCLE:String = 'sort-circle';
		public static const SORT_CIRCLE_DOWN:String = 'sort-circle-down';
		public static const SORT_CIRCLE_UP:String = 'sort-circle-up';
		public static const SORT_SHAPES_DOWN:String = 'sort-shapes-down';
		public static const SORT_SHAPES_DOWN_ALT:String = 'sort-shapes-down-alt';
		public static const SORT_SHAPES_UP:String = 'sort-shapes-up';
		public static const SORT_SHAPES_UP_ALT:String = 'sort-shapes-up-alt';
		public static const SORT_SIZE_DOWN:String = 'sort-size-down';
		public static const SORT_SIZE_DOWN_ALT:String = 'sort-size-down-alt';
		public static const SORT_SIZE_UP:String = 'sort-size-up';
		public static const SORT_SIZE_UP_ALT:String = 'sort-size-up-alt';
		public static const SOUP:String = 'soup';
		public static const SPACE_STATION_MOON:String = 'space-station-moon';
		public static const SPACE_STATION_MOON_ALT:String = 'space-station-moon-alt';
		public static const SPADE:String = 'spade';
		public static const SPARKLES:String = 'sparkles';
		public static const SPEAKER:String = 'speaker';
		public static const SPEAKERS:String = 'speakers';
		public static const SPIDER_BLACK_WIDOW:String = 'spider-black-widow';
		public static const SPIDER_WEB:String = 'spider-web';
		public static const SPINNER_THIRD:String = 'spinner-third';
		public static const SPRINKLER:String = 'sprinkler';
		public static const SQUARE_ROOT:String = 'square-root';
		public static const SQUIRREL:String = 'squirrel';
		public static const STAFF:String = 'staff';
		public static const STAR_CHRISTMAS:String = 'star-christmas';
		public static const STAR_EXCLAMATION:String = 'star-exclamation';
		public static const STARFIGHTER:String = 'starfighter';
		public static const STARFIGHTER_ALT:String = 'starfighter-alt';
		public static const STARS:String = 'stars';
		public static const STARSHIP:String = 'starship';
		public static const STARSHIP_FREIGHTER:String = 'starship-freighter';
		public static const STAR_SHOOTING:String = 'star-shooting';
		public static const STEAK:String = 'steak';
		public static const STEERING_WHEEL:String = 'steering-wheel';
		public static const STOCKING:String = 'stocking';
		public static const STOMACH:String = 'stomach';
		public static const STRETCHER:String = 'stretcher';
		public static const SUN_CLOUD:String = 'sun-cloud';
		public static const SUN_DUST:String = 'sun-dust';
		public static const SUNGLASSES:String = 'sunglasses';
		public static const SUN_HAZE:String = 'sun-haze';
		public static const SUNRISE:String = 'sunrise';
		public static const SUNSET:String = 'sunset';
		public static const SWORD:String = 'sword';
		public static const SWORD_LASER:String = 'sword-laser';
		public static const SWORD_LASER_ALT:String = 'sword-laser-alt';
		public static const SWORDS:String = 'swords';
		public static const SWORDS_LASER:String = 'swords-laser';
		public static const TABLET_ANDROID:String = 'tablet-android';
		public static const TABLET_ANDROID_ALT:String = 'tablet-android-alt';
		public static const TABLET_RUGGED:String = 'tablet-rugged';
		public static const TACHOMETER:String = 'tachometer';
		public static const TACHOMETER_ALT_AVERAGE:String = 'tachometer-alt-average';
		public static const TACHOMETER_ALT_FAST:String = 'tachometer-alt-fast';
		public static const TACHOMETER_ALT_FASTEST:String = 'tachometer-alt-fastest';
		public static const TACHOMETER_ALT_SLOW:String = 'tachometer-alt-slow';
		public static const TACHOMETER_ALT_SLOWEST:String = 'tachometer-alt-slowest';
		public static const TACHOMETER_AVERAGE:String = 'tachometer-average';
		public static const TACHOMETER_FAST:String = 'tachometer-fast';
		public static const TACHOMETER_FASTEST:String = 'tachometer-fastest';
		public static const TACHOMETER_SLOW:String = 'tachometer-slow';
		public static const TACHOMETER_SLOWEST:String = 'tachometer-slowest';
		public static const TACO:String = 'taco';
		public static const TALLY:String = 'tally';
		public static const TANAKH:String = 'tanakh';
		public static const TASKS_ALT:String = 'tasks-alt';
		public static const TELESCOPE:String = 'telescope';
		public static const TEMPERATURE_DOWN:String = 'temperature-down';
		public static const TEMPERATURE_FRIGID:String = 'temperature-frigid';
		public static const TEMPERATURE_HOT:String = 'temperature-hot';
		public static const TEMPERATURE_UP:String = 'temperature-up';
		public static const TENNIS_BALL:String = 'tennis-ball';
		public static const TEXT:String = 'text';
		public static const TEXT_SIZE:String = 'text-size';
		public static const THETA:String = 'theta';
		public static const THUNDERSTORM:String = 'thunderstorm';
		public static const THUNDERSTORM_MOON:String = 'thunderstorm-moon';
		public static const THUNDERSTORM_SUN:String = 'thunderstorm-sun';
		public static const TICKET:String = 'ticket';
		public static const TILDE:String = 'tilde';
		public static const TIMES_HEXAGON:String = 'times-hexagon';
		public static const TIMES_OCTAGON:String = 'times-octagon';
		public static const TIMES_SQUARE:String = 'times-square';
		public static const TIRE:String = 'tire';
		public static const TIRE_FLAT:String = 'tire-flat';
		public static const TIRE_PRESSURE_WARNING:String = 'tire-pressure-warning';
		public static const TIRE_RUGGED:String = 'tire-rugged';
		public static const TOILET_PAPER_ALT:String = 'toilet-paper-alt';
		public static const TOMBSTONE:String = 'tombstone';
		public static const TOMBSTONE_ALT:String = 'tombstone-alt';
		public static const TOOTHBRUSH:String = 'toothbrush';
		public static const TORNADO:String = 'tornado';
		public static const TRAFFIC_CONE:String = 'traffic-cone';
		public static const TRAFFIC_LIGHT_GO:String = 'traffic-light-go';
		public static const TRAFFIC_LIGHT_SLOW:String = 'traffic-light-slow';
		public static const TRAFFIC_LIGHT_STOP:String = 'traffic-light-stop';
		public static const TRANSPORTER:String = 'transporter';
		public static const TRANSPORTER_1:String = 'transporter-1';
		public static const TRANSPORTER_2:String = 'transporter-2';
		public static const TRANSPORTER_3:String = 'transporter-3';
		public static const TRANSPORTER_EMPTY:String = 'transporter-empty';
		public static const TRASH_UNDO:String = 'trash-undo';
		public static const TRASH_UNDO_ALT:String = 'trash-undo-alt';
		public static const TREASURE_CHEST:String = 'treasure-chest';
		public static const TREE_ALT:String = 'tree-alt';
		public static const TREE_CHRISTMAS:String = 'tree-christmas';
		public static const TREE_DECORATED:String = 'tree-decorated';
		public static const TREE_LARGE:String = 'tree-large';
		public static const TREE_PALM:String = 'tree-palm';
		public static const TREES:String = 'trees';
		public static const TRIANGLE:String = 'triangle';
		public static const TRIANGLE_MUSIC:String = 'triangle-music';
		public static const TROPHY_ALT:String = 'trophy-alt';
		public static const TRUCK_CONTAINER:String = 'truck-container';
		public static const TRUCK_COUCH:String = 'truck-couch';
		public static const TRUCK_PLOW:String = 'truck-plow';
		public static const TRUCK_RAMP:String = 'truck-ramp';
		public static const TRUMPET:String = 'trumpet';
		public static const TURKEY:String = 'turkey';
		public static const TURNTABLE:String = 'turntable';
		public static const TURTLE:String = 'turtle';
		public static const TV_ALT:String = 'tv-alt';
		public static const TV_MUSIC:String = 'tv-music';
		public static const TV_RETRO:String = 'tv-retro';
		public static const TYPEWRITER:String = 'typewriter';
		public static const UFO:String = 'ufo';
		public static const UFO_BEAM:String = 'ufo-beam';
		public static const UNICORN:String = 'unicorn';
		public static const UNION:String = 'union';
		public static const USB_DRIVE:String = 'usb-drive';
		public static const USD_CIRCLE:String = 'usd-circle';
		public static const USD_SQUARE:String = 'usd-square';
		public static const USER_ALIEN:String = 'user-alien';
		public static const USER_CHART:String = 'user-chart';
		public static const USER_COWBOY:String = 'user-cowboy';
		public static const USER_CROWN:String = 'user-crown';
		public static const USER_HARD_HAT:String = 'user-hard-hat';
		public static const USER_HEADSET:String = 'user-headset';
		public static const USER_MD_CHAT:String = 'user-md-chat';
		public static const USER_MUSIC:String = 'user-music';
		public static const USER_ROBOT:String = 'user-robot';
		public static const USERS_CLASS:String = 'users-class';
		public static const USERS_CROWN:String = 'users-crown';
		public static const USERS_MEDICAL:String = 'users-medical';
		public static const USER_UNLOCK:String = 'user-unlock';
		public static const USER_VISOR:String = 'user-visor';
		public static const UTENSIL_FORK:String = 'utensil-fork';
		public static const UTENSIL_KNIFE:String = 'utensil-knife';
		public static const UTENSILS_ALT:String = 'utensils-alt';
		public static const VACUUM:String = 'vacuum';
		public static const VACUUM_ROBOT:String = 'vacuum-robot';
		public static const VALUE_ABSOLUTE:String = 'value-absolute';
		public static const VHS:String = 'vhs';
		public static const VIDEO_PLUS:String = 'video-plus';
		public static const VIOLIN:String = 'violin';
		public static const VOLCANO:String = 'volcano';
		public static const VOLUME:String = 'volume';
		public static const VOLUME_SLASH:String = 'volume-slash';
		public static const VOTE_NAY:String = 'vote-nay';
		public static const WAGON_COVERED:String = 'wagon-covered';
		public static const WALKER:String = 'walker';
		public static const WALKIE_TALKIE:String = 'walkie-talkie';
		public static const WAND:String = 'wand';
		public static const WAND_MAGIC:String = 'wand-magic';
		public static const WAREHOUSE_ALT:String = 'warehouse-alt';
		public static const WASHER:String = 'washer';
		public static const WATCH:String = 'watch';
		public static const WATCH_CALCULATOR:String = 'watch-calculator';
		public static const WATCH_FITNESS:String = 'watch-fitness';
		public static const WATER_LOWER:String = 'water-lower';
		public static const WATER_RISE:String = 'water-rise';
		public static const WAVEFORM:String = 'waveform';
		public static const WAVEFORM_PATH:String = 'waveform-path';
		public static const WAVE_SINE:String = 'wave-sine';
		public static const WAVE_TRIANGLE:String = 'wave-triangle';
		public static const WEBCAM:String = 'webcam';
		public static const WEBCAM_SLASH:String = 'webcam-slash';
		public static const WHALE:String = 'whale';
		public static const WHEAT:String = 'wheat';
		public static const WHISTLE:String = 'whistle';
		public static const WIFI_1:String = 'wifi-1';
		public static const WIFI_2:String = 'wifi-2';
		public static const WIFI_SLASH:String = 'wifi-slash';
		public static const WINDOW:String = 'window';
		public static const WINDOW_ALT:String = 'window-alt';
		public static const WINDOW_FRAME:String = 'window-frame';
		public static const WINDOW_FRAME_OPEN:String = 'window-frame-open';
		public static const WINDSOCK:String = 'windsock';
		public static const WIND_TURBINE:String = 'wind-turbine';
		public static const WIND_WARNING:String = 'wind-warning';
		public static const WREATH:String = 'wreath';

    }
}