/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.visitor.as;

import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorIsNode;
import org.apache.royale.compiler.internal.tree.as.ConfigConditionBlockNode;
import org.apache.royale.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IBlockNode;
import org.apache.royale.compiler.tree.as.ICatchNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefaultXMLNamespaceNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.IIterationFlowNode;
import org.apache.royale.compiler.tree.as.IKeywordNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.compiler.tree.as.IObjectLiteralValuePairNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IReturnNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.ISwitchNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;
import org.apache.royale.compiler.tree.as.ITernaryOperatorNode;
import org.apache.royale.compiler.tree.as.IThrowNode;
import org.apache.royale.compiler.tree.as.ITryNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IUseNamespaceNode;
import org.apache.royale.compiler.tree.as.IVariableExpressionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.as.IWhileLoopNode;
import org.apache.royale.compiler.tree.as.IWithNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;
import org.apache.royale.compiler.visitor.IASNodeStrategy;
import org.apache.royale.compiler.visitor.IBlockVisitor;
import org.apache.royale.compiler.visitor.as.IASBlockVisitor;

public class ASNodeSwitch
implements IASNodeStrategy {
    private IASBlockVisitor visitor;

    public ASNodeSwitch(IBlockVisitor visitor) {
        this.visitor = (IASBlockVisitor)visitor;
    }

    @Override
    public void handle(IASNode node) {
        if (node == null) {
            return;
        }
        switch (node.getNodeID()) {
            case ContainerID: {
                this.visitor.visitContainer((IContainerNode)node);
                return;
            }
            case ConfigBlockID: {
                ConfigConditionBlockNode condcomp = (ConfigConditionBlockNode)node;
                if (condcomp.getChildCount() > 0) {
                    this.visitor.visitBlock((IBlockNode)node);
                }
                return;
            }
            case E4XFilterID: {
                this.visitor.visitE4XFilter((IMemberAccessExpressionNode)node);
                return;
            }
            case FileID: {
                this.visitor.visitFile((IFileNode)node);
                return;
            }
            case PackageID: {
                this.visitor.visitPackage((IPackageNode)node);
                return;
            }
            case ClassID: {
                this.visitor.visitClass((IClassNode)node);
                return;
            }
            case InterfaceID: {
                this.visitor.visitInterface((IInterfaceNode)node);
                return;
            }
            case GetterID: {
                this.visitor.visitGetter((IGetterNode)node);
                return;
            }
            case SetterID: {
                this.visitor.visitSetter((ISetterNode)node);
                return;
            }
            case FunctionID: {
                this.visitor.visitFunction((IFunctionNode)node);
                return;
            }
            case ArgumentID: 
            case ArgumentRestID: {
                this.visitor.visitParameter((IParameterNode)node);
                return;
            }
            case VariableID: 
            case BindableVariableID: {
                this.visitor.visitVariable((IVariableNode)node);
                return;
            }
            case NamespaceID: {
                this.visitor.visitNamespace((INamespaceNode)node);
                return;
            }
            case CatchID: {
                this.visitor.visitCatch((ICatchNode)node);
                return;
            }
            case ForEachLoopID: 
            case ForLoopID: {
                this.visitor.visitForLoop((IForLoopNode)node);
                return;
            }
            case FinallyID: 
            case DefaultID: 
            case ElseID: 
            case TerminalID: {
                this.visitor.visitTerminal((ITerminalNode)node);
                return;
            }
            case TryID: {
                this.visitor.visitTry((ITryNode)node);
                return;
            }
            case WithID: {
                this.visitor.visitWith((IWithNode)node);
                return;
            }
            case IfStatementID: {
                this.visitor.visitIf((IIfNode)node);
                return;
            }
            case SwitchID: {
                this.visitor.visitSwitch((ISwitchNode)node);
                return;
            }
            case WhileLoopID: 
            case DoWhileLoopID: {
                this.visitor.visitWhileLoop((IWhileLoopNode)node);
                return;
            }
            case FunctionCallID: {
                this.visitor.visitFunctionCall((IFunctionCallNode)node);
                return;
            }
            case TypedExpressionID: {
                this.visitor.visitTypedExpression((ITypedExpressionNode)node);
                return;
            }
            case IdentifierID: 
            case NamespaceIdentifierID: 
            case NonResolvingIdentifierID: {
                if (node instanceof ILanguageIdentifierNode) {
                    this.visitor.visitLanguageIdentifierNode((ILanguageIdentifierNode)node);
                    return;
                }
                this.visitor.visitIdentifier((IIdentifierNode)node);
                return;
            }
            case LiteralIntegerID: 
            case LiteralUintID: {
                this.visitor.visitNumericLiteral((INumericLiteralNode)node);
                return;
            }
            case ArrayIndexExpressionID: {
                this.visitor.visitDynamicAccess((IDynamicAccessNode)node);
                return;
            }
            case ReturnStatementID: {
                this.visitor.visitReturn((IReturnNode)node);
                return;
            }
            case ThrowsStatementID: {
                this.visitor.visitThrow((IThrowNode)node);
                return;
            }
            case TernaryExpressionID: {
                this.visitor.visitTernaryOperator((ITernaryOperatorNode)node);
                return;
            }
            case BlockID: {
                this.visitor.visitBlock((IBlockNode)node);
                return;
            }
            case LabledStatementID: {
                this.visitor.visitLabeledStatement((LabeledStatementNode)node);
                return;
            }
            case BreakID: 
            case ContinueID: 
            case GotoID: {
                this.visitor.visitIterationFlow((IIterationFlowNode)node);
                return;
            }
            case SuperID: 
            case VoidID: {
                this.visitor.visitLanguageIdentifierNode((ILanguageIdentifierNode)node);
                return;
            }
            case DefaultXMLStatementID: {
                this.visitor.visitDefaultXMLNamespace((IDefaultXMLNamespaceNode)node);
                return;
            }
            case VariableExpressionID: {
                this.visitor.visitVariableExpression((IVariableExpressionNode)node);
                return;
            }
            case FunctionObjectID: 
            case AnonymousFunctionID: {
                this.visitor.visitFunctionObject((IFunctionObjectNode)node);
                return;
            }
        }
        if (node instanceof IUseNamespaceNode) {
            this.visitor.visitUseNamespace((IUseNamespaceNode)node);
        } else if (node instanceof IEmbedNode) {
            this.visitor.visitEmbed((IEmbedNode)node);
        } else if (node instanceof IObjectLiteralValuePairNode) {
            this.visitor.visitObjectLiteralValuePair((IObjectLiteralValuePairNode)node);
        } else if (node instanceof NamespaceAccessExpressionNode) {
            this.visitor.visitNamespaceAccessExpression((INamespaceAccessExpressionNode)node);
        } else if (node instanceof IMemberAccessExpressionNode) {
            this.visitor.visitMemberAccessExpression((IMemberAccessExpressionNode)node);
        } else if (node instanceof IBinaryOperatorNode) {
            if (node instanceof BinaryOperatorAsNode) {
                this.visitor.visitAsOperator((IBinaryOperatorNode)node);
            } else if (node instanceof BinaryOperatorIsNode) {
                this.visitor.visitIsOperator((IBinaryOperatorNode)node);
            } else {
                this.visitor.visitBinaryOperator((IBinaryOperatorNode)node);
            }
        } else if (node instanceof IUnaryOperatorNode) {
            this.visitor.visitUnaryOperator((IUnaryOperatorNode)node);
        } else if (node instanceof IKeywordNode) {
            this.visitor.visitKeyword((IKeywordNode)node);
        } else if (node instanceof IMetaTagsNode) {
            this.visitor.visitMetaTags((IMetaTagsNode)node);
        } else if (node instanceof IMetaTagNode) {
            this.visitor.visitMetaTag((IMetaTagNode)node);
        } else if (node instanceof IImportNode) {
            this.visitor.visitImport((IImportNode)node);
        } else if (node instanceof ILiteralNode) {
            this.visitor.visitLiteral((ILiteralNode)node);
        } else if (node instanceof IExpressionNode) {
            this.visitor.visitExpression((IExpressionNode)node);
        } else {
            throw new RuntimeException("handle() not found " + node.getClass().getName());
        }
    }
}

