/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.IPathResolver;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.ConfigurationPathResolver;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.linter.ASLinter;
import org.apache.royale.linter.LinterSettings;
import org.apache.royale.linter.LinterUtils;
import org.apache.royale.linter.MXMLLinter;
import org.apache.royale.linter.config.CommandLineConfigurator;
import org.apache.royale.linter.config.Configuration;
import org.apache.royale.linter.config.ConfigurationBuffer;
import org.apache.royale.linter.config.ConfigurationValue;
import org.apache.royale.linter.config.Configurator;
import org.apache.royale.linter.internal.BaseLinter;
import org.apache.royale.utils.FilenameNormalization;

public class LINTER {
    private static final String DEFAULT_VAR = "files";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    private static final String FILE_EXTENSION_ACTIONSCRIPT = ".as";
    private static final String FILE_EXTENSION_MXML = ".mxml";
    private ProblemQuery problemQuery;
    private List<File> inputFiles = new ArrayList<File>();
    private Configuration configuration;
    private ConfigurationBuffer configBuffer;
    private LinterSettings settings = new LinterSettings();

    public static void main(String[] args) {
        LINTER formatter = new LINTER();
        int exitCode = formatter.execute(args);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) {
        ExitCode exitCode = ExitCode.SUCCESS;
        this.problemQuery = new ProblemQuery();
        this.problemQuery.setShowWarnings(false);
        try {
            boolean continueLinting = this.configure(args, this.problemQuery);
            if (continueLinting) {
                for (File inputFile : this.inputFiles) {
                    BaseLinter linter;
                    String filePath = FilenameNormalization.normalize((String)inputFile.getAbsolutePath());
                    FileSpecification fileSpec = new FileSpecification(filePath);
                    String fileText = IOUtils.toString((Reader)fileSpec.createReader());
                    if (filePath.endsWith(FILE_EXTENSION_MXML)) {
                        linter = new MXMLLinter(this.settings);
                        ((MXMLLinter)linter).lint(filePath, fileText, this.problemQuery.getProblems());
                        continue;
                    }
                    linter = new ASLinter(this.settings);
                    ((ASLinter)linter).lint(filePath, fileText, this.problemQuery.getProblems());
                }
            } else {
                exitCode = this.problemQuery.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
            }
        }
        catch (Exception e) {
            this.problemQuery.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
            System.err.println(e.getMessage());
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
        }
        finally {
            if (this.problemQuery.hasFilteredProblems()) {
                Workspace workspace = new Workspace();
                CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer();
                WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(workspace, categorizer);
                ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                printer.printProblems(this.problemQuery.getFilteredProblems());
            }
        }
        return exitCode.getCode();
    }

    protected String getStartMessage() {
        String message = "Apache Royale ActionScript Linter (aslint)\n" + VersionInfo.buildMessage() + "\n";
        return message;
    }

    protected String getProgramName() {
        return "aslint";
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        if (helpVar != null) {
            for (ConfigurationValue val : helpVar) {
                Iterator<String> iterator = val.getArgs().iterator();
                while (iterator.hasNext()) {
                    String element;
                    String keyword = element = iterator.next();
                    while (keyword.startsWith("-")) {
                        keyword = keyword.substring(1);
                    }
                    keywords.add(keyword);
                }
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        System.out.println(this.getStartMessage());
        System.out.println(usages);
    }

    private boolean configure(String[] args, ProblemQuery problems) {
        try {
            Configurator configurator = new Configurator();
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            configurator.setConfigurationPathResolver((IPathResolver)resolver);
            configurator.setConfiguration(args, DEFAULT_VAR);
            this.configuration = configurator.getConfiguration();
            this.configBuffer = configurator.getConfigurationBuffer();
            problems.addAll(configurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null || args.length == 0 && this.configuration.getFiles().size() == 0) {
                this.processHelp(helpVar);
                return false;
            }
            if (problems.hasErrors()) {
                return false;
            }
            this.settings = LinterUtils.configurationToLinterSettings(this.configuration);
            if (this.settings.rules.size() == 0) {
                ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, "No linter rules were specified");
                problems.add((ICompilerProblem)problem);
                return false;
            }
            for (String filePath : this.configuration.getFiles()) {
                File inputFile = new File(filePath);
                if (!inputFile.exists()) {
                    ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, "Input file does not exist: " + filePath);
                    problems.add((ICompilerProblem)problem);
                    return false;
                }
                if (inputFile.isDirectory()) {
                    this.addDirectory(inputFile);
                    continue;
                }
                this.inputFiles.add(inputFile);
            }
            if (this.inputFiles.size() == 0) {
                ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, "Missing input file(s)");
                problems.add((ICompilerProblem)problem);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            problems.add((ICompilerProblem)problem);
            return false;
        }
    }

    private void addDirectory(File inputFile) {
        for (File file : inputFile.listFiles()) {
            String fileName = file.getName();
            if (fileName.startsWith(".")) continue;
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (!fileName.endsWith(FILE_EXTENSION_ACTIONSCRIPT) && !fileName.endsWith(FILE_EXTENSION_MXML)) continue;
            this.inputFiles.add(file);
        }
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

