/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

public abstract class QualifiedName {
    private static final String THIS = "this".intern();
    private static final String SUPER = "super".intern();

    private QualifiedName() {
    }

    public static QualifiedName of(String string) {
        int index;
        int lastIndex = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        do {
            builder.add(string.substring(lastIndex, (index = string.indexOf(46, lastIndex)) < 0 ? string.length() : index).intern());
            lastIndex = index + 1;
        } while (index >= 0);
        ImmutableCollection terms = builder.build();
        return new StringListQname((ImmutableList<String>)terms, terms.size());
    }

    @Nullable
    public abstract QualifiedName getOwner();

    public abstract String getComponent();

    public abstract boolean isSimple();

    abstract void appendTo(StringBuilder var1);

    public abstract boolean matches(Node var1);

    public Iterable<String> components() {
        ImmutableList.Builder<String> components = ImmutableList.builder();
        this.buildComponents(components);
        return components.build();
    }

    private void buildComponents(ImmutableList.Builder<String> builder) {
        QualifiedName owner = this.getOwner();
        if (owner != null) {
            owner.buildComponents(builder);
        }
        builder.add((Object)this.getComponent());
    }

    public String join() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    public QualifiedName getprop(String propertyName) {
        return new GetpropQname(this, propertyName);
    }

    static final class NodeQname
    extends QualifiedName {
        private final Node node;

        NodeQname(Node n) {
            this.node = n;
        }

        @Override
        public QualifiedName getOwner() {
            return this.node.isGetProp() ? new NodeQname(this.node.getFirstChild()) : null;
        }

        @Override
        public String getComponent() {
            switch (this.node.getToken()) {
                case GETPROP: {
                    return this.node.getLastChild().getString();
                }
                case THIS: {
                    return THIS;
                }
                case SUPER: {
                    return SUPER;
                }
                case NAME: 
                case MEMBER_FUNCTION_DEF: {
                    return this.node.getString();
                }
            }
            throw new IllegalStateException("Not a qualified name: " + this.node);
        }

        @Override
        public boolean isSimple() {
            return !this.node.isGetProp();
        }

        @Override
        void appendTo(StringBuilder sb) {
            sb.append(this.join());
        }

        @Override
        public String join() {
            return this.node.getQualifiedName();
        }

        @Override
        public boolean matches(Node n) {
            return n.matchesQualifiedName(this.node);
        }
    }

    private static class GetpropQname
    extends QualifiedName {
        final QualifiedName owner;
        final String prop;

        GetpropQname(QualifiedName owner, String prop) {
            this.owner = owner;
            this.prop = prop.intern();
        }

        @Override
        public QualifiedName getOwner() {
            return this.owner;
        }

        @Override
        public String getComponent() {
            return this.prop;
        }

        @Override
        public boolean isSimple() {
            return false;
        }

        @Override
        void appendTo(StringBuilder sb) {
            this.owner.appendTo(sb);
            sb.append('.').append(this.prop);
        }

        @Override
        public boolean matches(Node n) {
            return n.isGetProp() && n.getLastChild().getString() == this.prop && this.owner.matches(n.getFirstChild());
        }
    }

    private static class StringListQname
    extends QualifiedName {
        final ImmutableList<String> terms;
        final int size;

        StringListQname(ImmutableList<String> terms, int size) {
            this.terms = terms;
            this.size = size;
        }

        @Override
        public QualifiedName getOwner() {
            return this.size > 1 ? new StringListQname(this.terms, this.size - 1) : null;
        }

        @Override
        public String getComponent() {
            return (String)this.terms.get(this.size - 1);
        }

        @Override
        public boolean isSimple() {
            return this.size == 1;
        }

        @Override
        void appendTo(StringBuilder sb) {
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append((String)this.terms.get(i));
            }
        }

        @Override
        public Iterable<String> components() {
            return this.terms.subList(0, this.size);
        }

        @Override
        public boolean matches(Node n) {
            int pos = this.size - 1;
            while (pos > 0 && n.isGetProp()) {
                if (n.getLastChild().getString() != this.terms.get(pos)) {
                    return false;
                }
                --pos;
                n = n.getFirstChild();
            }
            if (pos > 0) {
                return false;
            }
            switch (n.getToken()) {
                case NAME: 
                case MEMBER_FUNCTION_DEF: {
                    return this.terms.get(0) == n.getString();
                }
                case THIS: {
                    return this.terms.get(0) == THIS;
                }
                case SUPER: {
                    return this.terms.get(0) == SUPER;
                }
            }
            return false;
        }
    }
}

