/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NameBasedDefinitionProvider;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.List;

public class DefinitionUseSiteFinder
extends NameBasedDefinitionProvider {
    private final Multimap<String, UseSite> useSitesByName = LinkedHashMultimap.create();
    private final Multimap<Node, NameAndUseSite> useSitesByScopeNode = HashMultimap.create();

    @VisibleForTesting
    Multimap<String, UseSite> getUseSitesByName() {
        return ImmutableMultimap.copyOf(this.useSitesByName);
    }

    public DefinitionUseSiteFinder(AbstractCompiler compiler) {
        super(compiler, false);
    }

    @Override
    public void process(Node externs, Node source) {
        super.process(externs, source);
        NodeTraversal.traverse(this.compiler, source, new UseSiteGatheringCallback());
    }

    public Collection<UseSite> getUseSites(DefinitionsRemover.Definition definition) {
        Preconditions.checkState(this.hasProcessBeenRun, "Hasn't been initialized with process() yet.");
        return this.useSitesByName.get(definition.getSimplifiedName());
    }

    static boolean isCallOrNewSite(UseSite use) {
        Node call = use.node.getParent();
        if (call == null) {
            return false;
        }
        return NodeUtil.isCallOrNew(call) && call.getFirstChild() == use.node;
    }

    boolean canModifyDefinition(DefinitionsRemover.Definition definition) {
        if (this.isExported(definition)) {
            return false;
        }
        Collection<UseSite> useSites = this.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        for (UseSite site : useSites) {
            Node nameNode = site.node;
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = this.getDefinitionsReferencedAt(nameNode);
            if (singleSiteDefinitions.size() > 1) {
                return false;
            }
            Preconditions.checkState(!singleSiteDefinitions.isEmpty());
            Preconditions.checkState(singleSiteDefinitions.contains(definition));
        }
        return true;
    }

    private boolean isExported(DefinitionsRemover.Definition definition) {
        String partialName;
        Node lValue = definition.getLValue();
        if (lValue == null) {
            return true;
        }
        if (lValue.isGetProp()) {
            partialName = lValue.getLastChild().getString();
        } else if (lValue.isName()) {
            partialName = lValue.getString();
        } else {
            return true;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        return codingConvention.isExported(partialName);
    }

    @Override
    public void rebuildScopeRoots(List<Node> changedScopeRoots, List<Node> deletedScopeRoots) {
        super.rebuildScopeRoots(changedScopeRoots, deletedScopeRoots);
        for (Node scopeRoot : Iterables.concat(deletedScopeRoots, changedScopeRoots)) {
            for (NameAndUseSite nameAndUseSite : this.useSitesByScopeNode.removeAll(scopeRoot)) {
                this.useSitesByName.remove(nameAndUseSite.name, nameAndUseSite.useSite);
            }
        }
        NodeTraversal.traverseScopeRoots(this.compiler, null, changedScopeRoots, new UseSiteGatheringCallback(), false);
    }

    void removeReferences(Node node) {
        if (DefinitionsRemover.isDefinitionNode(node)) {
            DefinitionsRemover.Definition definition;
            String name;
            Node definitionSiteNode = node;
            DefinitionSite definitionSite = (DefinitionSite)this.definitionSitesByDefinitionSiteNode.get(definitionSiteNode);
            if (definitionSite != null && (name = (definition = definitionSite.definition).getSimplifiedName()) != null) {
                Node definitionNode = definition.getLValue();
                this.definitionNodes.remove(definitionNode);
                this.definitionsByName.remove(name, definition);
                this.definitionSitesByDefinitionSiteNode.remove(definitionSiteNode);
                Node scopeNode = NodeUtil.getEnclosingChangeScopeRoot(definitionSiteNode);
                this.definitionSitesByScopeNode.remove(scopeNode, definitionSite);
            }
        } else {
            String name;
            String propName;
            Node useSiteNode = node;
            if (useSiteNode.isGetProp() && ((propName = useSiteNode.getLastChild().getString()).equals("apply") || propName.equals("call"))) {
                useSiteNode = useSiteNode.getFirstChild();
            }
            if ((name = DefinitionUseSiteFinder.getSimplifiedName(useSiteNode)) != null) {
                UseSite useSite = new UseSite(useSiteNode, null, null);
                this.useSitesByName.remove(name, useSite);
                this.useSitesByScopeNode.remove(NodeUtil.getEnclosingChangeScopeRoot(useSiteNode), new NameAndUseSite(name, useSite));
            }
        }
        for (Node child : node.children()) {
            this.removeReferences(child);
        }
    }

    private class UseSiteGatheringCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private UseSiteGatheringCallback() {
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            if (!node.isGetProp() && !node.isName()) {
                return;
            }
            Collection<DefinitionsRemover.Definition> defs = DefinitionUseSiteFinder.this.getDefinitionsReferencedAt(node);
            if (defs.isEmpty()) {
                return;
            }
            DefinitionsRemover.Definition first = defs.iterator().next();
            String name = NameBasedDefinitionProvider.getSimplifiedName(first.getLValue());
            Preconditions.checkNotNull(name);
            UseSite useSite = new UseSite(node, traversal.getScope(), traversal.getModule());
            DefinitionUseSiteFinder.this.useSitesByName.put(name, useSite);
            DefinitionUseSiteFinder.this.useSitesByScopeNode.put(NodeUtil.getEnclosingChangeScopeRoot(node), new NameAndUseSite(name, useSite));
        }
    }

    private static class NameAndUseSite {
        final String name;
        final UseSite useSite;

        NameAndUseSite(String name, UseSite useSite) {
            this.name = name;
            this.useSite = useSite;
        }
    }
}

